/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.MetricsJmxConfig;
import com.hazelcast.internal.util.Preconditions;
import java.util.Objects;
import javax.annotation.Nonnull;

public abstract class BaseMetricsConfig<T extends BaseMetricsConfig> {
    private static final int DEFAULT_METRICS_COLLECTION_SECONDS = 5;
    protected boolean enabled = true;
    protected MetricsJmxConfig jmxConfig = new MetricsJmxConfig();
    protected int collectionFrequencySeconds = 5;

    protected BaseMetricsConfig() {
    }

    protected BaseMetricsConfig(BaseMetricsConfig metricsConfig) {
        this.enabled = metricsConfig.enabled;
        this.jmxConfig = new MetricsJmxConfig(metricsConfig.jmxConfig);
        this.collectionFrequencySeconds = metricsConfig.collectionFrequencySeconds;
    }

    @Nonnull
    public T setEnabled(boolean enabled) {
        this.enabled = enabled;
        return (T)this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nonnull
    public T setJmxConfig(MetricsJmxConfig jmxConfig) {
        this.jmxConfig = Objects.requireNonNull(jmxConfig, "JMX config must not be null");
        return (T)this;
    }

    @Nonnull
    public MetricsJmxConfig getJmxConfig() {
        return this.jmxConfig;
    }

    @Nonnull
    public T setCollectionFrequencySeconds(int intervalSeconds) {
        Preconditions.checkPositive(intervalSeconds, "collectionFrequencySeconds must be positive");
        this.collectionFrequencySeconds = intervalSeconds;
        return (T)this;
    }

    public int getCollectionFrequencySeconds() {
        return this.collectionFrequencySeconds;
    }
}

