/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy.txn;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.ClientConnection;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientDestroyProxyCodec;
import com.hazelcast.client.impl.proxy.txn.ClientTransactionUtil;
import com.hazelcast.client.impl.spi.ClientTransactionContext;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.partition.strategy.StringPartitioningStrategy;
import com.hazelcast.transaction.TransactionalObject;
import java.util.UUID;

abstract class ClientTxnProxy
implements TransactionalObject {
    final String name;
    final ClientTransactionContext transactionContext;

    ClientTxnProxy(String name, ClientTransactionContext transactionContext) {
        this.name = name;
        this.transactionContext = transactionContext;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPartitionKey() {
        return StringPartitioningStrategy.getPartitionKey(this.name);
    }

    @Override
    public final void destroy() {
        this.onDestroy();
        ClientMessage request = ClientDestroyProxyCodec.encodeRequest(this.name, this.getServiceName());
        this.invoke(request);
    }

    abstract void onDestroy();

    final ClientMessage invoke(ClientMessage request) {
        HazelcastClientInstanceImpl client = this.transactionContext.getClient();
        ClientConnection connection = this.transactionContext.getConnection();
        return ClientTransactionUtil.invoke(request, this.getName(), client, connection);
    }

    UUID getTransactionId() {
        return this.transactionContext.getTxnId();
    }

    Data toData(Object obj) {
        return this.transactionContext.getClient().getSerializationService().toData(obj);
    }

    Object toObject(Data data) {
        return this.transactionContext.getClient().getSerializationService().toObject(data);
    }

    SerializationService getSerializationService() {
        return this.transactionContext.getClient().getSerializationService();
    }
}

