/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.custom.AnchorDataListHolderCodec;
import com.hazelcast.client.impl.protocol.codec.holder.AnchorDataListHolder;
import com.hazelcast.client.impl.protocol.codec.holder.PagingPredicateHolder;
import com.hazelcast.internal.serialization.Data;
import java.util.List;

public final class PagingPredicateHolderCodec {
    private static final int PAGE_SIZE_FIELD_OFFSET = 0;
    private static final int PAGE_FIELD_OFFSET = 4;
    private static final int ITERATION_TYPE_ID_FIELD_OFFSET = 8;
    private static final int INITIAL_FRAME_SIZE = 9;

    private PagingPredicateHolderCodec() {
    }

    public static void encode(ClientMessage clientMessage, PagingPredicateHolder pagingPredicateHolder) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[9]);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, pagingPredicateHolder.getPageSize());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 4, pagingPredicateHolder.getPage());
        FixedSizeTypesCodec.encodeByte(initialFrame.content, 8, pagingPredicateHolder.getIterationTypeId());
        clientMessage.add(initialFrame);
        AnchorDataListHolderCodec.encode(clientMessage, pagingPredicateHolder.getAnchorDataListHolder());
        CodecUtil.encodeNullable(clientMessage, pagingPredicateHolder.getPredicateData(), DataCodec::encode);
        CodecUtil.encodeNullable(clientMessage, pagingPredicateHolder.getComparatorData(), DataCodec::encode);
        CodecUtil.encodeNullable(clientMessage, pagingPredicateHolder.getPartitionKeyData(), DataCodec::encode);
        ListMultiFrameCodec.encodeNullable(clientMessage, pagingPredicateHolder.getPartitionKeysData(), DataCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static PagingPredicateHolder decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        int pageSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 0);
        int page = FixedSizeTypesCodec.decodeInt(initialFrame.content, 4);
        byte iterationTypeId = FixedSizeTypesCodec.decodeByte(initialFrame.content, 8);
        AnchorDataListHolder anchorDataListHolder = AnchorDataListHolderCodec.decode(iterator);
        Data predicateData = CodecUtil.decodeNullable(iterator, DataCodec::decode);
        Data comparatorData = CodecUtil.decodeNullable(iterator, DataCodec::decode);
        Data partitionKeyData = CodecUtil.decodeNullable(iterator, DataCodec::decode);
        boolean isPartitionKeysDataExists = false;
        List<Data> partitionKeysData = null;
        if (!iterator.peekNext().isEndFrame()) {
            partitionKeysData = ListMultiFrameCodec.decodeNullable(iterator, DataCodec::decode);
            isPartitionKeysDataExists = true;
        }
        CodecUtil.fastForwardToEndFrame(iterator);
        return new PagingPredicateHolder(anchorDataListHolder, predicateData, comparatorData, pageSize, page, iterationTypeId, partitionKeyData, isPartitionKeysDataExists, partitionKeysData);
    }
}

