/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.WanReplicationRefCodec;
import com.hazelcast.config.WanReplicationRef;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;

public final class MCUpdateMapConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x200400;
    public static final int RESPONSE_MESSAGE_TYPE = 2098177;
    private static final int REQUEST_TIME_TO_LIVE_SECONDS_FIELD_OFFSET = 16;
    private static final int REQUEST_MAX_IDLE_SECONDS_FIELD_OFFSET = 20;
    private static final int REQUEST_EVICTION_POLICY_FIELD_OFFSET = 24;
    private static final int REQUEST_READ_BACKUP_DATA_FIELD_OFFSET = 28;
    private static final int REQUEST_MAX_SIZE_FIELD_OFFSET = 29;
    private static final int REQUEST_MAX_SIZE_POLICY_FIELD_OFFSET = 33;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 37;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private MCUpdateMapConfigCodec() {
    }

    public static ClientMessage encodeRequest(String mapName, int timeToLiveSeconds, int maxIdleSeconds, int evictionPolicy, boolean readBackupData, int maxSize, int maxSizePolicy, @Nullable WanReplicationRef wanReplicationRef) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("MC.UpdateMapConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[37], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x200400);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, timeToLiveSeconds);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 20, maxIdleSeconds);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 24, evictionPolicy);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 28, readBackupData);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 29, maxSize);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 33, maxSizePolicy);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, mapName);
        CodecUtil.encodeNullable(clientMessage, wanReplicationRef, WanReplicationRefCodec::encode);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.timeToLiveSeconds = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        request.maxIdleSeconds = FixedSizeTypesCodec.decodeInt(initialFrame.content, 20);
        request.evictionPolicy = FixedSizeTypesCodec.decodeInt(initialFrame.content, 24);
        request.readBackupData = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 28);
        request.maxSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 29);
        request.maxSizePolicy = FixedSizeTypesCodec.decodeInt(initialFrame.content, 33);
        request.mapName = StringCodec.decode(iterator);
        if (iterator.hasNext()) {
            request.wanReplicationRef = CodecUtil.decodeNullable(iterator, WanReplicationRefCodec::decode);
            request.isWanReplicationRefExists = true;
        } else {
            request.isWanReplicationRefExists = false;
        }
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 2098177);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String mapName;
        public int timeToLiveSeconds;
        public int maxIdleSeconds;
        public int evictionPolicy;
        public boolean readBackupData;
        public int maxSize;
        public int maxSizePolicy;
        @Nullable
        public WanReplicationRef wanReplicationRef;
        public boolean isWanReplicationRefExists;
    }
}

