/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.RoutingStrategy;
import com.hazelcast.client.impl.connection.tcp.RoutingMode;
import java.util.Objects;

public class ClusterRoutingConfig {
    public static final RoutingStrategy DEFAULT_ROUTING_STRATEGY = RoutingStrategy.PARTITION_GROUPS;
    public static final RoutingMode DEFAULT_ROUTING_MODE = RoutingMode.ALL_MEMBERS;
    private RoutingMode routingMode = DEFAULT_ROUTING_MODE;
    private RoutingStrategy routingStrategy = DEFAULT_ROUTING_STRATEGY;

    public ClusterRoutingConfig() {
    }

    public ClusterRoutingConfig(ClusterRoutingConfig clusterRoutingConfig) {
        this.routingMode = clusterRoutingConfig.routingMode;
        this.routingStrategy = clusterRoutingConfig.routingStrategy;
    }

    public RoutingMode getRoutingMode() {
        return this.routingMode;
    }

    public ClusterRoutingConfig setRoutingMode(RoutingMode routingMode) {
        this.routingMode = routingMode;
        return this;
    }

    public RoutingStrategy getRoutingStrategy() {
        return this.routingStrategy;
    }

    public ClusterRoutingConfig setRoutingStrategy(RoutingStrategy routingStrategy) {
        this.routingStrategy = routingStrategy;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterRoutingConfig that = (ClusterRoutingConfig)o;
        return this.routingMode == that.routingMode && this.routingStrategy == that.routingStrategy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.routingMode, this.routingStrategy});
    }

    public String toString() {
        return "ClusterRoutingConfig{routingMode=" + this.routingMode + ", routingStrategy=" + this.routingStrategy + "}";
    }
}

