/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.BasicObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.CellID;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.Compact64bitInt;

public class CellIDArray
extends BasicObject {
    public long count;
    public List<CellID> content;

    public CellIDArray(long count, List<CellID> content) {
        this.count = count;
        this.content = content;
    }

    public CellIDArray(CellIDArray cellIdArray) {
        this.count = cellIdArray.count;
        if (cellIdArray.content != null) {
            for (CellID cellId : cellIdArray.content) {
                this.content.add(new CellID(cellId));
            }
        }
    }

    public CellIDArray() {
        this.content = new ArrayList<CellID>();
    }

    @Override
    public List<Byte> serializeToByteList() throws IOException {
        ArrayList<Byte> byteList = new ArrayList<Byte>(new Compact64bitInt(this.count).serializeToByteList());
        if (this.content != null) {
            for (CellID extendGuid : this.content) {
                byteList.addAll(extendGuid.serializeToByteList());
            }
        }
        return byteList;
    }

    @Override
    protected int doDeserializeFromByteArray(byte[] byteArray, int startIndex) throws TikaException, IOException {
        AtomicInteger index = new AtomicInteger(startIndex);
        this.count = BasicObject.parse(byteArray, index, Compact64bitInt.class).getDecodedValue();
        for (long i = 0L; i < this.count; ++i) {
            this.content.add(BasicObject.parse(byteArray, index, CellID.class));
        }
        return index.get() - startIndex;
    }
}

