/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.jquery;

import de.agilecoders.wicket.jquery.settings.IWicketJquerySelectorsSettings;
import de.agilecoders.wicket.jquery.settings.WicketJquerySelectorsSettings;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WicketJquerySelectors {
    private static final Logger LOG = LoggerFactory.getLogger((String)"wicket-jquery-selectors");
    private static final MetaDataKey<IWicketJquerySelectorsSettings> JQUERY_SELECTORS_SETTINGS_METADATA_KEY = new MetaDataKey<IWicketJquerySelectorsSettings>(){};

    public static boolean isInstalled(Application application) {
        return application != null && application.getMetaData(JQUERY_SELECTORS_SETTINGS_METADATA_KEY) != null;
    }

    public static void install(Application app) {
        WicketJquerySelectors.install(app, null);
    }

    public static void install(Application app, IWicketJquerySelectorsSettings settings) {
        IWicketJquerySelectorsSettings existingSettings = WicketJquerySelectors.settings(app);
        if (existingSettings == null) {
            if (settings == null) {
                settings = new WicketJquerySelectorsSettings();
            }
            app.setMetaData(JQUERY_SELECTORS_SETTINGS_METADATA_KEY, (Object)settings);
            LOG.info("initialize wicket jquery selectors with given settings: {}", (Object)settings);
        }
    }

    public static IWicketJquerySelectorsSettings settings(Application app) {
        return (IWicketJquerySelectorsSettings)app.getMetaData(JQUERY_SELECTORS_SETTINGS_METADATA_KEY);
    }

    public static IWicketJquerySelectorsSettings assignedSettingsOrDefault() {
        Application app;
        Object object = app = Application.exists() ? Application.get() : null;
        if (WicketJquerySelectors.isInstalled(app)) {
            return WicketJquerySelectors.settings();
        }
        LOG.info("try to get settings, but WicketJquerySelectors wasn't installed to current application. Fallback to default settings.");
        return new WicketJquerySelectorsSettings();
    }

    public static IWicketJquerySelectorsSettings settings() {
        if (Application.exists()) {
            IWicketJquerySelectorsSettings settings = (IWicketJquerySelectorsSettings)Application.get().getMetaData(JQUERY_SELECTORS_SETTINGS_METADATA_KEY);
            if (settings != null) {
                return settings;
            }
            throw new IllegalStateException("you have to call WicketJquerySelectors.install()");
        }
        throw new IllegalStateException("there is no active application assigned to this thread.");
    }

    private WicketJquerySelectors() {
        throw new UnsupportedOperationException();
    }
}

