/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.user.chat;

import com.github.openjson.JSONObject;
import jakarta.inject.Inject;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.openmeetings.core.util.ChatWebSocketHelper;
import org.apache.openmeetings.core.util.WebSocketHelper;
import org.apache.openmeetings.db.dao.basic.ChatDao;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.basic.ChatMessage;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.app.ClientManager;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.MainPanel;
import org.apache.openmeetings.web.room.RoomPanel;
import org.apache.openmeetings.web.user.chat.ChatForm;
import org.apache.openmeetings.web.util.CallbackFunctionHelper;
import org.apache.openmeetings.web.util.ProfileImageResourceReference;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.JavaScriptUrlReferenceHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.ResourceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.jquery.ui.settings.JQueryUILibrarySettings;

public class Chat
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(Chat.class);
    private static final String PARAM_MSG_ID = "msgId";
    private static final String PARAM_ROOM_ID = "roomId";
    private static final String PARAM_TYPE = "type";
    private boolean showDashboardChat;
    private final AbstractDefaultAjaxBehavior chatActivity = new AbstractDefaultAjaxBehavior(){
        private static final long serialVersionUID = 1L;

        protected void respond(AjaxRequestTarget target) {
            try {
                String type = Chat.this.getRequest().getRequestParameters().getParameterValue(Chat.PARAM_TYPE).toString(null);
                long roomId = Chat.this.getRequest().getRequestParameters().getParameterValue(Chat.PARAM_ROOM_ID).toLong();
                if ("accept".equals(type)) {
                    long msgId = Chat.this.getRequest().getRequestParameters().getParameterValue(Chat.PARAM_MSG_ID).toLong();
                    ChatMessage m = Chat.this.chatDao.get(msgId);
                    if (m.isNeedModeration() && RoomPanel.isModerator(Chat.this.cm, WebSession.getUserId(), roomId)) {
                        m.setNeedModeration(false);
                        Chat.this.chatDao.update(m);
                        ChatWebSocketHelper.sendRoom((ChatMessage)m, (JSONObject)Chat.this.getMessage(List.of(m)).put("mode", (Object)"accept"));
                    } else {
                        log.error("It seems like we are being hacked!!!!");
                    }
                } else if (type != null && type.indexOf("typing") > -1) {
                    WebSocketHelper.sendRoom((Long)roomId, (JSONObject)new JSONObject().put(Chat.PARAM_TYPE, (Object)"typing").put("active", type.indexOf("start") > -1).put("uid", (Object)this.getUid()));
                }
            }
            catch (Exception e) {
                log.error("Unexpected exception while accepting chat message", (Throwable)e);
            }
        }

        private String getUid() {
            return Chat.this.getClient().getUid();
        }
    };
    @Inject
    private ClientManager cm;
    @Inject
    private ConfigurationDao cfgDao;
    @Inject
    private ChatDao chatDao;
    @Inject
    private UserDao userDao;

    public Chat(String id) {
        super(id);
        this.showDashboardChat = this.cfgDao.getBool("dashboard.show.chat", true);
        this.setOutputMarkupPlaceholderTag(true);
        this.setMarkupId(id);
    }

    protected void onInitialize() {
        this.add(new Behavior[]{this.chatActivity});
        this.add(new Component[]{new ChatForm("sendForm")});
        super.onInitialize();
    }

    private Client getClient() {
        return ((MainPanel)((Object)this.findParent(MainPanel.class))).getClient();
    }

    public JSONObject getMessage(List<ChatMessage> list) {
        Client c = this.getClient();
        User curUser = c == null ? this.userDao.get(WebSession.getUserId()) : c.getUser();
        return Chat.getMessage(curUser, list);
    }

    public static JSONObject getMessage(User curUser, List<ChatMessage> list) {
        return ChatWebSocketHelper.getMessage((User)curUser, list, (o, u) -> o.put("img", (Object)ProfileImageResourceReference.getUrl(RequestCycle.get(), u)));
    }

    public CharSequence getReinit() {
        StringBuilder sb = new StringBuilder("Chat.reinit(").append(new JSONObject().put("userId", (Object)WebSession.getUserId()).put("all", (Object)this.getString("1494")).put("room", (Object)this.getString("406")).put("sendOnEnter", OpenmeetingsVariables.isChatSendOnEnter()).toString()).append("); ");
        return this.processGlobal(sb);
    }

    public CharSequence processGlobal(StringBuilder sb) {
        if (!this.showDashboardChat) {
            sb.append(String.format("Chat.removeTab('%s');", "chatTab-all"));
        }
        return sb;
    }

    public CharSequence addRoom(Room r) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Chat.addTab('%1$s%2$d', '%3$s %2$d');", "chatTab-r", r.getId(), this.getString("406")));
        List list = this.chatDao.getRoom(r.getId().longValue(), 0L, 30L, !r.isChatModerated() || RoomPanel.isModerator(this.cm, WebSession.getUserId(), r.getId()));
        if (!list.isEmpty()) {
            sb.append("Chat.addMessage(").append(this.getMessage(list).toString()).append(");");
        }
        return sb;
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)new JavaScriptUrlReferenceHeaderItem("js/chat.js", "om-chat"){
            private static final long serialVersionUID = 1L;

            public List<HeaderItem> getDependencies() {
                return List.of(new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)"const bstooltip = jQuery.fn.tooltip;", (String)"preserve-bs-tooltip")), new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)JQueryUILibrarySettings.get().getJavaScriptReference())), new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forScript((CharSequence)"jQuery.fn.tooltip = bstooltip;", (String)"restore-bs-tooltip")));
            }
        }));
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)CallbackFunctionHelper.getNamedFunction("chatActivity", this.chatActivity, CallbackParameter.explicit((String)PARAM_TYPE), CallbackParameter.explicit((String)PARAM_ROOM_ID), CallbackParameter.explicit((String)PARAM_MSG_ID))));
        if (this.showDashboardChat) {
            StringBuilder sb = new StringBuilder(this.getReinit());
            ArrayList<ChatMessage> list = new ArrayList<ChatMessage>(this.chatDao.getGlobal(0L, 30L));
            list.addAll(this.chatDao.getUserRecent(WebSession.getUserId().longValue(), Date.from(Instant.now().minus(Duration.ofHours(1L))), 0L, 30L));
            if (!list.isEmpty()) {
                sb.append("Chat.addMessage(").append(this.getMessage(list).toString()).append(");");
            }
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)sb.toString()));
        }
    }

    public boolean isShowDashboardChat() {
        return this.showDashboardChat;
    }
}

