/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.ldap.client.api.future;

import java.util.concurrent.TimeUnit;
import org.apache.directory.api.ldap.model.message.Response;
import org.apache.directory.ldap.client.api.LdapConnection;
import org.apache.directory.ldap.client.api.future.ResponseFuture;

public abstract class UniqueResponseFuture<R extends Response>
implements ResponseFuture<R> {
    private R response;
    protected boolean cancelled = false;
    protected Throwable cause;
    protected int messageId;
    protected LdapConnection connection;
    private volatile boolean done = false;

    public UniqueResponseFuture(LdapConnection connection, int messageId) {
        this.messageId = messageId;
        this.connection = connection;
    }

    @Override
    public synchronized R get() throws InterruptedException {
        while (!this.done && !this.cancelled) {
            this.wait();
        }
        return this.response;
    }

    @Override
    public synchronized R get(long timeout, TimeUnit unit) throws InterruptedException {
        if (!this.done && !this.cancelled) {
            this.wait(unit.toMillis(timeout));
        }
        return this.response;
    }

    @Override
    public synchronized void set(R response) throws InterruptedException {
        this.response = response;
        this.done = response != null;
        this.notifyAll();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.cancelled) {
            return this.cancelled;
        }
        this.cancelled = true;
        if (!this.connection.isRequestCompleted(this.messageId)) {
            this.connection.abandon(this.messageId);
        }
        try {
            this.set(null);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.cancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        try {
            this.set(null);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[msgId : ").append(this.messageId).append(", ");
        sb.append("Canceled :").append(this.cancelled).append("]");
        return sb.toString();
    }
}

