/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.syntaxCheckers;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.SyntaxChecker;
import org.apache.directory.api.util.Strings;

public final class BootParameterSyntaxChecker
extends SyntaxChecker {
    public static final BootParameterSyntaxChecker INSTANCE = new BootParameterSyntaxChecker("1.3.6.1.1.1.0.1");

    private BootParameterSyntaxChecker(String oid) {
        super(oid);
    }

    public static Builder builder() {
        return new Builder();
    }

    private int parseKeyString(String strValue, int pos, char limit) {
        try {
            char c = strValue.charAt(pos);
            if (c == limit) {
                return pos;
            }
            if (!Character.isUpperCase(c) && !Character.isLowerCase(c)) {
                return -1;
            }
            c = strValue.charAt(++pos);
            while (c != limit) {
                if (!(Character.isUpperCase(c) || Character.isLowerCase(c) || Character.isDigit(c) || c == '-' || c == ';' || c == '_')) {
                    return -1;
                }
                c = strValue.charAt(++pos);
            }
            return pos;
        }
        catch (IndexOutOfBoundsException ioobe) {
            return -1;
        }
    }

    private int parseKeyString(String strValue, int pos) {
        try {
            char c = strValue.charAt(pos);
            if (Character.isUpperCase(c) || Character.isLowerCase(c)) {
                ++pos;
            } else {
                return -1;
            }
            while (pos < strValue.length()) {
                c = strValue.charAt(pos);
                if (Character.isUpperCase(c) || Character.isLowerCase(c) || Character.isDigit(c) || c == '-' || c == ';' || c == '_') {
                    ++pos;
                    continue;
                }
                return -1;
            }
            return pos;
        }
        catch (IndexOutOfBoundsException ioobe) {
            return -1;
        }
    }

    @Override
    public boolean isValidSyntax(Object value) {
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, "null"));
            }
            return false;
        }
        String strValue = value instanceof String ? (String)value : (value instanceof byte[] ? Strings.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() < 5) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        int pos = this.parseKeyString(strValue, 0, '=');
        if (pos == -1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        if (strValue.charAt(pos) != '=') {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        ++pos;
        if ((pos = this.parseKeyString(strValue, pos, ':')) == -1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        if (strValue.charAt(pos) != ':') {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        ++pos;
        if ((pos = this.parseKeyString(strValue, pos)) == -1) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.err(I18n.ERR_13210_SYNTAX_INVALID, value));
            }
            return false;
        }
        return true;
    }

    public static final class Builder
    extends SyntaxChecker.SCBuilder<BootParameterSyntaxChecker> {
        private Builder() {
            super("1.3.6.1.1.1.0.1");
        }

        @Override
        public BootParameterSyntaxChecker build() {
            return new BootParameterSyntaxChecker(this.oid);
        }
    }
}

