/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LoadableSchemaObject;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.api.util.Strings;

public final class SchemaUtils {
    private SchemaUtils() {
    }

    public static Entry getTargetEntry(List<? extends Modification> mods, Entry entry) throws LdapException {
        Entry targetEntry = entry.clone();
        block8: for (Modification modification : mods) {
            String id = modification.getAttribute().getId();
            switch (modification.getOperation()) {
                case REPLACE_ATTRIBUTE: {
                    targetEntry.put(modification.getAttribute());
                    break;
                }
                case ADD_ATTRIBUTE: {
                    Attribute combined = modification.getAttribute().clone();
                    Attribute toBeAdded = modification.getAttribute();
                    Attribute existing = entry.get(id);
                    if (existing != null) {
                        for (Object value : existing) {
                            combined.add(new Value[]{value});
                        }
                    }
                    for (Object value : toBeAdded) {
                        combined.add(new Value[]{value});
                    }
                    targetEntry.put(combined);
                    break;
                }
                case REMOVE_ATTRIBUTE: {
                    Object value;
                    Attribute toBeRemoved = modification.getAttribute();
                    if (toBeRemoved.size() == 0) {
                        targetEntry.removeAttributes(id);
                        break;
                    }
                    Attribute existing = targetEntry.get(id);
                    if (existing == null) continue block8;
                    value = toBeRemoved.iterator();
                    while (value.hasNext()) {
                        Value value2 = (Value)value.next();
                        existing.remove(value2);
                    }
                    continue block8;
                }
                case INCREMENT_ATTRIBUTE: {
                    AttributeType attributeType = modification.getAttribute().getAttributeType();
                    String incrementStr = modification.getAttribute().getString();
                    int increment = 1;
                    if (!Strings.isEmpty(incrementStr)) {
                        try {
                            increment = Integer.parseInt(incrementStr);
                        }
                        catch (NumberFormatException nfe) {
                            throw new IllegalArgumentException(I18n.err(I18n.ERR_13866_MOD_INCREMENT_INVALID_VALUE, attributeType.getName(), incrementStr));
                        }
                    }
                    Attribute modified = targetEntry.get(attributeType);
                    if (!targetEntry.containsAttribute(attributeType)) {
                        throw new IllegalArgumentException(I18n.err(I18n.ERR_13867_MOD_INCREMENT_NO_ATTRIBUTE, attributeType.getName()));
                    }
                    if (!"1.3.6.1.4.1.1466.115.121.1.27".equals(modified.getAttributeType().getSyntax().getOid())) {
                        throw new IllegalArgumentException(I18n.err(I18n.ERR_13868_MOD_INCREMENT_NO_INT_ATTRIBUTE, attributeType.getName()));
                    }
                    Value[] newValues = new Value[modified.size()];
                    int i = 0;
                    for (Value value : modified) {
                        int intValue = Integer.parseInt(value.getNormalized());
                        if (intValue == Integer.MAX_VALUE) {
                            throw new IllegalArgumentException(I18n.err(I18n.ERR_13869_MOD_INCREMENT_OVERFLOW, attributeType.getName(), intValue));
                        }
                        newValues[i++] = new Value(Integer.toString(intValue + increment));
                        modified.remove(value);
                    }
                    modified.add(newValues);
                    break;
                }
                default: {
                    throw new IllegalStateException(I18n.err(I18n.ERR_13775_UNDEFINED_MODIFICATION_TYPE, new Object[]{modification.getOperation()}));
                }
            }
        }
        return targetEntry;
    }

    public static StringBuilder render(StringBuilder buf, List<String> qdescrs) {
        if (qdescrs == null || qdescrs.isEmpty()) {
            return buf;
        }
        if (qdescrs.size() == 1) {
            buf.append("'").append(qdescrs.get(0)).append("'");
        } else {
            buf.append("( ");
            for (String qdescr : qdescrs) {
                buf.append("'").append(qdescr).append("' ");
            }
            buf.append(")");
        }
        return buf;
    }

    static StringBuilder renderQDescrs(StringBuilder buf, List<String> qdescrs) {
        if (qdescrs == null || qdescrs.isEmpty()) {
            return buf;
        }
        if (qdescrs.size() == 1) {
            buf.append('\'').append(qdescrs.get(0)).append('\'');
        } else {
            buf.append("( ");
            for (String qdescr : qdescrs) {
                buf.append('\'').append(qdescr).append("' ");
            }
            buf.append(")");
        }
        return buf;
    }

    private static StringBuilder renderQDString(StringBuilder buf, String qdString) {
        buf.append('\'');
        block4: for (char c : qdString.toCharArray()) {
            switch (c) {
                case '\'': {
                    buf.append("\\27");
                    continue block4;
                }
                case '\\': {
                    buf.append("\\5C");
                    continue block4;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        buf.append('\'');
        return buf;
    }

    public static StringBuilder render(ObjectClass[] ocs) {
        StringBuilder buf = new StringBuilder();
        return SchemaUtils.render(buf, ocs);
    }

    public static StringBuilder render(StringBuilder buf, ObjectClass[] ocs) {
        if (ocs == null || ocs.length == 0) {
            return buf;
        }
        if (ocs.length == 1) {
            buf.append(ocs[0].getName());
        } else {
            buf.append("( ");
            for (int ii = 0; ii < ocs.length; ++ii) {
                if (ii + 1 < ocs.length) {
                    buf.append(ocs[ii].getName()).append(" $ ");
                    continue;
                }
                buf.append(ocs[ii].getName());
            }
            buf.append(" )");
        }
        return buf;
    }

    public static StringBuilder render(AttributeType[] ats) {
        StringBuilder buf = new StringBuilder();
        return SchemaUtils.render(buf, ats);
    }

    public static StringBuilder render(StringBuilder buf, AttributeType[] ats) {
        if (ats == null || ats.length == 0) {
            return buf;
        }
        if (ats.length == 1) {
            buf.append(ats[0].getName());
        } else {
            buf.append("( ");
            for (int ii = 0; ii < ats.length; ++ii) {
                if (ii + 1 < ats.length) {
                    buf.append(ats[ii].getName()).append(" $ ");
                    continue;
                }
                buf.append(ats[ii].getName());
            }
            buf.append(" )");
        }
        return buf;
    }

    public static StringBuilder render(Map<String, List<String>> extensions) {
        StringBuilder buf = new StringBuilder();
        if (extensions.isEmpty()) {
            return buf;
        }
        for (Map.Entry<String, List<String>> entry : extensions.entrySet()) {
            buf.append(" ").append(entry.getKey()).append(" ");
            List<String> values = entry.getValue();
            if (values == null || values.isEmpty()) continue;
            if (values.size() == 1) {
                buf.append("'").append(values.get(0)).append("' ");
                continue;
            }
            buf.append("( ");
            for (String value : values) {
                buf.append("'").append(value).append("' ");
            }
            buf.append(")");
        }
        if (buf.charAt(buf.length() - 1) != ' ') {
            buf.append(" ");
        }
        return buf;
    }

    public static String render(LoadableSchemaObject description) {
        StringBuilder buf = new StringBuilder();
        buf.append("( ").append(description.getOid());
        if (description.getDescription() != null) {
            buf.append(" DESC ");
            SchemaUtils.renderQDString(buf, description.getDescription());
        }
        buf.append(" FQCN ").append(description.getFqcn());
        if (!Strings.isEmpty(description.getBytecode())) {
            buf.append(" BYTECODE ").append(description.getBytecode());
        }
        buf.append(" X-SCHEMA '");
        buf.append(SchemaUtils.getSchemaName(description));
        buf.append("' )");
        return buf.toString();
    }

    private static String getSchemaName(SchemaObject desc) {
        List<String> values = desc.getExtension("X-SCHEMA");
        if (values == null || values.isEmpty()) {
            return "other";
        }
        return values.get(0);
    }

    public static String stripOptions(String attributeId) {
        int optionsPos = attributeId.indexOf(59);
        if (optionsPos != -1) {
            return attributeId.substring(0, optionsPos);
        }
        return attributeId;
    }

    public static Set<String> getOptions(String attributeId) {
        int optionsPos = attributeId.indexOf(59);
        if (optionsPos != -1) {
            String[] res;
            HashSet<String> options = new HashSet<String>();
            for (String option : res = attributeId.substring(optionsPos + 1).split(";")) {
                if (Strings.isEmpty(option)) continue;
                options.add(option);
            }
            return options;
        }
        return null;
    }

    public static byte[] uuidToBytes(UUID uuid) {
        Long low = uuid.getLeastSignificantBits();
        Long high = uuid.getMostSignificantBits();
        byte[] bytes = new byte[]{(byte)((high & 0xFF00000000000000L) >> 56), (byte)((high & 0xFF000000000000L) >> 48), (byte)((high & 0xFF0000000000L) >> 40), (byte)((high & 0xFF00000000L) >> 32), (byte)((high & 0xFF000000L) >> 24), (byte)((high & 0xFF0000L) >> 16), (byte)((high & 0xFF00L) >> 8), (byte)(high & 0xFFL), (byte)((low & 0xFF00000000000000L) >> 56), (byte)((low & 0xFF000000000000L) >> 48), (byte)((low & 0xFF0000000000L) >> 40), (byte)((low & 0xFF00000000L) >> 32), (byte)((low & 0xFF000000L) >> 24), (byte)((low & 0xFF0000L) >> 16), (byte)((low & 0xFF00L) >> 8), (byte)(low & 0xFFL)};
        return bytes;
    }

    public static boolean isAttributeNameValid(String attributeName) {
        boolean descr;
        if (Strings.isEmpty(attributeName)) {
            return false;
        }
        boolean zero = false;
        boolean dot = false;
        char c = attributeName.charAt(0);
        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
            descr = true;
        } else if (c >= '0' && c <= '9') {
            descr = false;
            zero = c == '0';
        } else {
            return false;
        }
        for (int i = 1; i < attributeName.length(); ++i) {
            c = attributeName.charAt(i);
            if (descr) {
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_') continue;
                return false;
            }
            if (c == '.') {
                if (dot) {
                    return false;
                }
                dot = true;
                zero = false;
                continue;
            }
            if (c >= '0' && c <= '9') {
                dot = false;
                if (zero) {
                    return false;
                }
                if (c != '0') continue;
                zero = true;
                continue;
            }
            return false;
        }
        return true;
    }
}

