/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.tftp;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.net.tftp.TFTPPacket;
import org.apache.commons.net.tftp.TFTPPacketException;

public abstract class TFTPRequestPacket
extends TFTPPacket {
    static final String[] modeStrings = new String[]{"netascii", "octet"};
    private static final byte[][] modeBytes = new byte[][]{{110, 101, 116, 97, 115, 99, 105, 105, 0}, {111, 99, 116, 101, 116, 0}};
    private final int mode;
    private final String fileName;
    private final Map<String, String> options = new HashMap<String, String>();

    TFTPRequestPacket(InetAddress destination, int port, int type, String fileName, int mode) {
        super(type, destination, port);
        this.fileName = fileName;
        this.mode = mode;
    }

    TFTPRequestPacket(int type, DatagramPacket datagram) throws TFTPPacketException {
        super(type, datagram.getAddress(), datagram.getPort());
        int modeIndex;
        int index;
        byte[] data = datagram.getData();
        if (this.getType() != data[1]) {
            throw new TFTPPacketException("TFTP operator code does not match type.");
        }
        StringBuilder buffer = new StringBuilder();
        int length = datagram.getLength();
        for (index = 2; index < length && data[index] != 0; ++index) {
            buffer.append((char)data[index]);
        }
        this.fileName = buffer.toString();
        if (index >= length) {
            throw new TFTPPacketException("Bad file name and mode format.");
        }
        buffer.setLength(0);
        ++index;
        while (index < length && data[index] != 0) {
            buffer.append((char)data[index]);
            ++index;
        }
        String modeString = buffer.toString().toLowerCase(Locale.ENGLISH);
        int modeStringsLength = modeStrings.length;
        int mode = 0;
        for (modeIndex = 0; modeIndex < modeStringsLength; ++modeIndex) {
            if (!modeString.equals(modeStrings[modeIndex])) continue;
            mode = modeIndex;
            break;
        }
        this.mode = mode;
        if (modeIndex >= modeStringsLength) {
            throw new TFTPPacketException("Unrecognized TFTP transfer mode: " + modeString);
        }
        ++index;
        while (index < length) {
            int start = index;
            while (data[index] != 0) {
                if (index >= length) {
                    throw new TFTPPacketException("Invalid option format");
                }
                ++index;
            }
            String option = new String(data, start, index - start, StandardCharsets.US_ASCII);
            start = ++index;
            while (data[index] != 0) {
                if (index >= length) {
                    throw new TFTPPacketException("Invalid option format");
                }
                ++index;
            }
            String octets = new String(data, start, index - start, StandardCharsets.US_ASCII);
            this.options.put(option, octets);
            ++index;
        }
    }

    public final String getFilename() {
        return this.fileName;
    }

    public final int getMode() {
        return this.mode;
    }

    public final Map<String, String> getOptions() {
        return this.options;
    }

    @Override
    public final DatagramPacket newDatagram() {
        int fileLength = this.fileName.length();
        int modeLength = modeBytes[this.mode].length;
        int optionsLength = 0;
        for (Map.Entry<String, String> entry : this.options.entrySet()) {
            optionsLength += entry.getKey().length() + 1 + entry.getValue().length() + 1;
        }
        byte[] data = new byte[fileLength + modeLength + 3 + optionsLength];
        data[0] = 0;
        data[1] = (byte)this.type;
        System.arraycopy(this.fileName.getBytes(Charset.defaultCharset()), 0, data, 2, fileLength);
        data[fileLength + 2] = 0;
        System.arraycopy(modeBytes[this.mode], 0, data, fileLength + 3, modeLength);
        if (optionsLength > 0) {
            this.handleOptions(data, fileLength, modeLength);
        }
        return new DatagramPacket(data, data.length, this.address, this.port);
    }

    @Override
    final DatagramPacket newDatagram(DatagramPacket datagram, byte[] data) {
        int fileLength = this.fileName.length();
        int modeLength = modeBytes[this.mode].length;
        data[0] = 0;
        data[1] = (byte)this.type;
        System.arraycopy(this.fileName.getBytes(Charset.defaultCharset()), 0, data, 2, fileLength);
        data[fileLength + 2] = 0;
        System.arraycopy(modeBytes[this.mode], 0, data, fileLength + 3, modeLength);
        this.handleOptions(data, fileLength, modeLength);
        datagram.setAddress(this.address);
        datagram.setPort(this.port);
        datagram.setData(data);
        datagram.setLength(fileLength + modeLength + 3);
        return datagram;
    }

    private void handleOptions(byte[] data, int fileLength, int modeLength) {
        int index = fileLength + modeLength + 2;
        for (Map.Entry<String, String> entry : this.options.entrySet()) {
            data[index] = 0;
            String key = entry.getKey();
            String value = entry.getValue();
            System.arraycopy(key.getBytes(StandardCharsets.US_ASCII), 0, data, ++index, key.length());
            index += key.length();
            data[index++] = 0;
            System.arraycopy(value.getBytes(StandardCharsets.US_ASCII), 0, data, index, value.length());
            index += value.length();
        }
    }
}

