/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import oracle.jdbc.SecurityInformation;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ns.NetException;
import oracle.net.nt.ConnOption;

@DefaultLogger(value="oracle.net")
@Supports(value={Feature.NET})
class DNVerifier {
    private static final int SSL_CERT_SAN_TYPE_DNS_NAME = 2;
    private static final int SSL_CERT_SAN_TYPE_IP_ADDR = 7;
    private final ConnOption connOption;
    private final boolean isDNmatchEnabled;
    private SecurityInformation.DNMatchStatus dnMatchStatus = SecurityInformation.DNMatchStatus.NOT_VERIFIED;

    DNVerifier(ConnOption connOption, boolean bl) {
        this.connOption = connOption;
        this.isDNmatchEnabled = bl;
    }

    SecurityInformation.DNMatchStatus verify(X509Certificate x509Certificate) throws IOException {
        if (!this.isDNmatchEnabled) {
            return SecurityInformation.DNMatchStatus.NOT_VERIFIED;
        }
        return this.verifyServerCertificate(x509Certificate);
    }

    boolean isWeakDNMatchAllowed() {
        ConnOption connOption = this.connOption.getOriginalConnOption();
        return connOption.sslAllowWeakDNMatch != null && (connOption.sslAllowWeakDNMatch.equalsIgnoreCase("on") || connOption.sslAllowWeakDNMatch.equalsIgnoreCase("true") || connOption.sslAllowWeakDNMatch.equalsIgnoreCase("yes"));
    }

    public SecurityInformation.DNMatchStatus verifyServerCertificate(X509Certificate x509Certificate) throws NetException, IOException {
        ConnOption connOption = this.connOption.getOriginalConnOption();
        if (connOption.sslServerCertDN != null) {
            return this.verifyConfiguredDN(x509Certificate, connOption.sslServerCertDN);
        }
        return this.verifyHostOrServiceName(x509Certificate);
    }

    private SecurityInformation.DNMatchStatus verifyConfiguredDN(X509Certificate x509Certificate, String string) throws NetException, IOException {
        String string2 = x509Certificate.getSubjectDN().getName();
        if (this.doFullDNMatch(string2, string)) {
            return SecurityInformation.DNMatchStatus.VERIFIED_MATCHING_CONFIG;
        }
        throw new NetException(405, null, false, string, string2);
    }

    private SecurityInformation.DNMatchStatus verifyHostOrServiceName(X509Certificate x509Certificate) throws NetException, IOException {
        ConnOption connOption = this.connOption.getOriginalConnOption();
        String string = this.connOption.host;
        String string2 = connOption.host;
        if (this.matchCNAndSANs(x509Certificate, string) || this.matchCNAndSANs(x509Certificate, string2)) {
            return SecurityInformation.DNMatchStatus.VERIFIED_MATCHING_HOSTNAME;
        }
        boolean bl = this.isWeakDNMatchAllowed();
        String string3 = connOption.service_name;
        if (!bl || string3 == null) {
            throw new NetException(416, null, false, string2, string, this.getCNValue(x509Certificate), Optional.ofNullable(this.getDNSSubjectAlts(x509Certificate)).map(Arrays::toString).orElse("null"));
        }
        if (this.matchSANs(x509Certificate, string3) || this.matchCN(x509Certificate, string3)) {
            return SecurityInformation.DNMatchStatus.VERIFIED_MATCHING_SERVICENAME;
        }
        throw new NetException(417, null, false, string2, string, string3, this.getCNValue(x509Certificate), Optional.ofNullable(this.getDNSSubjectAlts(x509Certificate)).map(Arrays::toString).orElse("null"));
    }

    private boolean doFullDNMatch(String string, String string2) throws IOException {
        if (string == null || string2 == null) {
            return false;
        }
        try {
            LdapName ldapName = new LdapName(string);
            LdapName ldapName2 = new LdapName(string2);
            return ldapName.equals(ldapName2);
        }
        catch (InvalidNameException invalidNameException) {
            throw new IOException(invalidNameException);
        }
    }

    private boolean matchCNAndSANs(X509Certificate x509Certificate, String string) throws IOException {
        return string != null && (this.matchSANs(x509Certificate, string) || this.matchCN(x509Certificate, string));
    }

    private boolean matchCN(X509Certificate x509Certificate, String string) throws IOException {
        String string2 = this.getCNValue(x509Certificate);
        return this.compare(string2, string);
    }

    private boolean matchSANs(X509Certificate x509Certificate, String string) throws IOException {
        String[] stringArray = this.getDNSSubjectAlts(x509Certificate);
        if (stringArray != null) {
            for (String string2 : stringArray) {
                if (!this.compare(string2, string)) continue;
                return true;
            }
        }
        return false;
    }

    private String[] getDNSSubjectAlts(X509Certificate x509Certificate) throws IOException {
        try {
            LinkedList<String> linkedList = new LinkedList<String>();
            Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
            if (collection == null) {
                return null;
            }
            for (List<?> list : collection) {
                Integer n2 = (Integer)list.get(0);
                if (n2 != 2 && n2 != 7) continue;
                linkedList.add((String)list.get(1));
            }
            return linkedList.toArray(new String[linkedList.size()]);
        }
        catch (CertificateParsingException certificateParsingException) {
            throw new IOException(certificateParsingException);
        }
    }

    private String getCNValue(X509Certificate x509Certificate) throws IOException {
        try {
            return this.getCNValue(new LdapName(x509Certificate.getSubjectDN().getName()));
        }
        catch (InvalidNameException invalidNameException) {
            throw new IOException(invalidNameException);
        }
    }

    private String getCNValue(LdapName ldapName) {
        for (Rdn rdn : ldapName.getRdns()) {
            if (!rdn.getType().equalsIgnoreCase("CN")) continue;
            return (String)rdn.getValue();
        }
        return null;
    }

    private boolean compare(String string, String string2) {
        String string3;
        String string4;
        if ((string = string.toLowerCase()).equals(string2 = string2.toLowerCase())) {
            return true;
        }
        int n2 = string.indexOf(46);
        int n3 = string2.indexOf(46);
        if (n2 > 0 && n3 > 0 && (string4 = string.substring(n2)).equals(string3 = string2.substring(n3))) {
            String string5 = string.substring(0, n2);
            String string6 = string2.substring(0, n3);
            return this.wildcardCompare(string5, string6);
        }
        return false;
    }

    private boolean wildcardCompare(String string, String string2) {
        if (string.equals("*")) {
            return !string2.isEmpty();
        }
        int n2 = string.indexOf(42);
        if (n2 == -1) {
            return false;
        }
        if (n2 == string.length() - 1) {
            return string2.startsWith(string.substring(0, string.length() - 1));
        }
        if (n2 == 0) {
            return string2.endsWith(string.substring(1));
        }
        String string3 = string.substring(0, n2);
        String string4 = string.substring(n2 + 1);
        return string2.startsWith(string3) && string2.endsWith(string4);
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

