/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.tree;

import java.sql.SQLException;
import java.sql.Wrapper;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonValue;

public class JsonpObjectImpl
extends AbstractMap<String, JsonValue>
implements Wrapper,
JsonObject {
    OracleJsonObject wrapped;

    public JsonpObjectImpl(OracleJsonObject oracleJsonObject) {
        this.wrapped = oracleJsonObject;
    }

    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.OBJECT;
    }

    public boolean getBoolean(String string) {
        return this.wrapped.getBoolean(string);
    }

    public boolean getBoolean(String string, boolean bl) {
        return this.wrapped.getBoolean(string, bl);
    }

    public int getInt(String string) {
        return this.wrapped.getInt(string);
    }

    public int getInt(String string, int n2) {
        return this.wrapped.getInt(string, n2);
    }

    public JsonArray getJsonArray(String string) {
        return ((OracleJsonValue)this.wrapped.get(string)).asJsonArray().wrap(JsonArray.class);
    }

    public JsonNumber getJsonNumber(String string) {
        return ((OracleJsonValue)this.wrapped.get(string)).wrap(JsonNumber.class);
    }

    public JsonObject getJsonObject(String string) {
        return ((OracleJsonValue)this.wrapped.get(string)).asJsonObject().wrap(JsonObject.class);
    }

    public JsonString getJsonString(String string) {
        return ((OracleJsonValue)this.wrapped.get(string)).wrap(JsonString.class);
    }

    public String getString(String string) {
        return ((JsonString)this.get(string)).getString();
    }

    public String getString(String string, String string2) {
        JsonValue jsonValue = this.get(string);
        if (jsonValue == null || jsonValue.getValueType() != JsonValue.ValueType.STRING) {
            return string2;
        }
        return ((JsonString)jsonValue).getString();
    }

    public boolean isNull(String string) {
        return this.wrapped.isNull(string);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            return clazz.cast(this.wrapped);
        }
        catch (ClassCastException classCastException) {
            throw new SQLException(classCastException.getMessage(), classCastException);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isAssignableFrom(OracleJsonObject.class);
    }

    @Override
    public Set<Map.Entry<String, JsonValue>> entrySet() {
        return new AbstractSet<Map.Entry<String, JsonValue>>(){

            @Override
            public Iterator<Map.Entry<String, JsonValue>> iterator() {
                return new Iterator<Map.Entry<String, JsonValue>>(){
                    Iterator<Map.Entry<String, OracleJsonValue>> iter;
                    {
                        this.iter = JsonpObjectImpl.this.wrapped.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public Map.Entry<String, JsonValue> next() {
                        final Map.Entry<String, OracleJsonValue> entry = this.iter.next();
                        return new Map.Entry<String, JsonValue>(){

                            @Override
                            public String getKey() {
                                return (String)entry.getKey();
                            }

                            @Override
                            public JsonValue getValue() {
                                return ((OracleJsonValue)entry.getValue()).wrap(JsonValue.class);
                            }

                            @Override
                            public JsonValue setValue(JsonValue jsonValue) {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                };
            }

            @Override
            public int size() {
                return JsonpObjectImpl.this.wrapped.size();
            }
        };
    }

    @Override
    public JsonValue get(Object object) {
        OracleJsonValue oracleJsonValue = (OracleJsonValue)this.wrapped.get(object);
        if (oracleJsonValue == null) {
            return null;
        }
        return oracleJsonValue.wrap(JsonValue.class);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.wrapped.containsKey(object);
    }
}

