/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
abstract class OracleBufferedStream
extends InputStream {
    private final IntFunction<byte[]> allocateFunction;
    private final Consumer<byte[]> cacheFunction;
    private byte[] resizableBuffer;
    int initialBufferSize;
    int currentBufferSize;
    int pos;
    int count;
    long maxPosition = Integer.MAX_VALUE;
    boolean closed;
    OracleStatement statement;

    protected OracleBufferedStream(int n2) {
        this(n2, byte[]::new, byArray -> {});
    }

    protected OracleBufferedStream(OracleStatement oracleStatement, int n2) {
        this(n2, oracleStatement.connection::getByteBufferSync, oracleStatement.connection::cacheBufferSync);
        this.statement = oracleStatement;
    }

    protected OracleBufferedStream(int n2, IntFunction<byte[]> intFunction, Consumer<byte[]> consumer) {
        this.allocateFunction = intFunction;
        this.cacheFunction = consumer;
        this.pos = 0;
        this.count = 0;
        this.closed = false;
        this.initialBufferSize = n2;
        this.currentBufferSize = 0;
        this.resizableBuffer = null;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.releaseBuffer();
    }

    public boolean needBytes() throws IOException {
        return this.needBytes(Math.max(this.initialBufferSize, this.currentBufferSize));
    }

    public abstract boolean needBytes(int var1) throws IOException;

    public int flushBytes(int n2) {
        int n3 = n2 > this.count - this.pos ? this.count - this.pos : n2;
        this.pos += n3;
        return n3;
    }

    public int writeBytes(byte[] byArray, int n2, int n3) {
        int n4 = n3 > this.count - this.pos ? this.count - this.pos : n3;
        System.arraycopy(this.resizableBuffer, this.pos, byArray, n2, n4);
        this.pos += n4;
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        if (this.statement == null) {
            OracleBufferedStream oracleBufferedStream = this;
            synchronized (oracleBufferedStream) {
                return this.readInternal();
            }
        }
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            return this.readInternal();
        }
    }

    private final int readInternal() throws IOException {
        if (this.closed || this.isNull()) {
            return -1;
        }
        if (this.needBytes()) {
            return this.resizableBuffer[this.pos++] & 0xFF;
        }
        this.releaseBuffer();
        return -1;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 == 0) {
            return 0;
        }
        if (this.statement == null) {
            OracleBufferedStream oracleBufferedStream = this;
            synchronized (oracleBufferedStream) {
                return this.readInternal(byArray, n2, n3);
            }
        }
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            return this.readInternal(byArray, n2, n3);
        }
    }

    private final int readInternal(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = n2;
        if (this.closed || this.isNull()) {
            return -1;
        }
        int n5 = n3 > byArray.length ? n4 + byArray.length : n4 + n3;
        if (!this.needBytes(n3)) {
            this.releaseBuffer();
            return -1;
        }
        n4 += this.writeBytes(byArray, n4, n5 - n4);
        while (n4 < n5 && this.needBytes(n5 - n4)) {
            n4 += this.writeBytes(byArray, n4, n5 - n4);
        }
        return n4 - n2;
    }

    @Override
    public int available() throws IOException {
        if (this.closed || this.isNull()) {
            return 0;
        }
        return this.count - this.pos;
    }

    public boolean isNull() throws IOException {
        return false;
    }

    @Override
    public void mark(int n2) {
    }

    @Override
    public void reset() throws IOException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            throw new IOException(DatabaseError.findMessage(194, null));
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(int n2) throws IOException {
        if (this.statement == null) {
            OracleBufferedStream oracleBufferedStream = this;
            synchronized (oracleBufferedStream) {
                return this.skipInternal(n2);
            }
        }
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            return this.skipInternal(n2);
        }
    }

    private final int skipInternal(int n2) throws IOException {
        int n3;
        int n4 = n2;
        if (this.closed || this.isNull()) {
            return -1;
        }
        if (!this.needBytes()) {
            this.releaseBuffer();
            return -1;
        }
        for (n3 = 0; n3 < n4 && this.needBytes(); n3 += this.flushBytes(n4 - n3)) {
        }
        return n3;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.statement.getConnectionDuringExceptionHandling();
    }

    protected final byte[] getBuffer(int n2) {
        if (this.resizableBuffer == null) {
            this.resizableBuffer = this.allocateFunction.apply(n2);
        } else if (this.resizableBuffer.length < n2) {
            this.cacheFunction.accept(this.resizableBuffer);
            this.resizableBuffer = this.allocateFunction.apply(n2);
        }
        return this.resizableBuffer;
    }

    private void releaseBuffer() {
        if (this.resizableBuffer != null) {
            this.cacheFunction.accept(this.resizableBuffer);
            this.resizableBuffer = null;
            this.currentBufferSize = 0;
        }
    }
}

