/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.behavior;

import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IComponentAwareEventSink;
import org.apache.wicket.IRequestListener;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.IComponentAwareHeaderContributor;
import org.apache.wicket.markup.parser.XmlTag;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Args;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

public abstract class Behavior
implements IClusterable,
IComponentAwareEventSink,
IComponentAwareHeaderContributor {
    private static final long serialVersionUID = 1L;

    public Behavior() {
        if (Application.exists()) {
            Application.get().getBehaviorInstantiationListeners().onInstantiation(this);
        }
    }

    public void beforeRender(Component component) {
    }

    public void afterRender(Component component) {
    }

    public void bind(Component component) {
    }

    public void unbind(Component component) {
    }

    public void detach(Component component) {
    }

    public void onException(Component component, RuntimeException exception) {
    }

    public boolean getStatelessHint(Component component) {
        return !(this instanceof IRequestListener);
    }

    public boolean isEnabled(Component component) {
        return true;
    }

    public void onComponentTag(Component component, ComponentTag tag) {
    }

    public boolean isTemporary(Component component) {
        return false;
    }

    public boolean canCallListener(Component component) {
        return this.isEnabled(component) && component.canCallListener();
    }

    @Override
    public void renderHead(Component component, IHeaderResponse response) {
    }

    public void onConfigure(Component component) {
    }

    @Override
    public void onEvent(Component component, IEvent<?> event) {
    }

    public void onRemove(Component component) {
    }

    public static Behavior onTag(final SerializableBiConsumer<Component, ComponentTag> onTagConsumer) {
        Args.notNull(onTagConsumer, (String)"onTagConsumer");
        return new Behavior(){

            @Override
            public void onComponentTag(Component component, ComponentTag tag) {
                onTagConsumer.accept((Object)component, (Object)tag);
            }
        };
    }

    public static Behavior onAttribute(final String name, final SerializableFunction<String, CharSequence> onAttribute) {
        Args.notEmpty((String)name, (String)"name");
        Args.notNull(onAttribute, (String)"onAttribute");
        return new Behavior(){
            private static final long serialVersionUID = 1L;

            @Override
            public void onComponentTag(Component component, ComponentTag tag) {
                if (tag.getType() != XmlTag.TagType.CLOSE) {
                    String oldValue = tag.getAttribute(name);
                    tag.put(name, (CharSequence)onAttribute.apply((Object)oldValue));
                }
            }
        };
    }
}

