/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.MessageHeaders;
import org.netpreserve.jwarc.MessageVersion;
import org.netpreserve.jwarc.WarcDigest;
import org.netpreserve.jwarc.WarcPayload;
import org.netpreserve.jwarc.WarcRecord;
import org.netpreserve.jwarc.WarcTargetRecord;

public class WarcConversion
extends WarcTargetRecord {
    WarcConversion(MessageVersion version, MessageHeaders headers, MessageBody body) {
        super(version, headers, body);
    }

    @Override
    public Optional<WarcPayload> payload() throws IOException {
        return Optional.of(new WarcPayload(this.body()){

            @Override
            public MediaType type() {
                return WarcConversion.this.contentType();
            }

            @Override
            Optional<MediaType> identifiedType() {
                return Optional.empty();
            }

            @Override
            public Optional<WarcDigest> digest() {
                Optional<WarcDigest> payloadDigest = WarcConversion.this.payloadDigest();
                return payloadDigest.isPresent() ? payloadDigest : WarcConversion.this.blockDigest();
            }
        });
    }

    public Optional<URI> refersTo() {
        return this.headers().sole("WARC-Refers-To").map(WarcRecord::parseRecordID);
    }

    public static class Builder
    extends WarcTargetRecord.Builder<WarcConversion, Builder> {
        public Builder() {
            super("conversion");
        }

        public Builder refersTo(URI recordId) {
            return (Builder)this.addHeader("WARC-Refers-To", WarcRecord.formatId(recordId));
        }

        @Override
        public WarcConversion build() {
            return this.build(WarcConversion::new);
        }
    }
}

