/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectHeaderStart;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectTypeHeaderStart;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.BitReader;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.BitWriter;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.ByteUtil;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.util.LittleEndianBitConverter;

public class StreamObjectHeaderStart16bit
extends StreamObjectHeaderStart {
    public StreamObjectHeaderStart16bit(StreamObjectTypeHeaderStart type, int length) throws TikaException {
        if (this.length > 127) {
            throw new TikaException("Field Length - 16-bit Stream Object Header Start, Length (7-bits): A 7-bit unsigned integer that specifies the length in bytes for additional data (if any). If the length is more than 127 bytes, a 32-bit stream object header start MUST be used.");
        }
        this.headerType = 0;
        this.type = type;
        this.compound = StreamObject.getCompoundTypes().contains((Object)this.type) ? 1 : 0;
        this.length = length;
    }

    public StreamObjectHeaderStart16bit(StreamObjectTypeHeaderStart type) throws TikaException {
        this(type, 0);
    }

    public StreamObjectHeaderStart16bit() {
    }

    @Override
    public List<Byte> serializeToByteList() throws IOException {
        BitWriter bitField = new BitWriter(2);
        bitField.appendInit32(this.headerType, 2);
        bitField.appendInit32(this.compound, 1);
        bitField.appendUInit32(this.type.getIntVal(), 6);
        bitField.appendInit32(this.length, 7);
        ArrayList<Byte> result = new ArrayList<Byte>();
        ByteUtil.appendByteArrayToListOfByte(result, bitField.getBytes());
        return result;
    }

    public short ToUint16() throws IOException {
        return LittleEndianBitConverter.ToUInt16(ByteUtil.toByteArray(this.serializeToByteList()), 0);
    }

    @Override
    protected int doDeserializeFromByteArray(byte[] byteArray, int startIndex) throws IOException, TikaException {
        BitReader bitReader = new BitReader(byteArray, startIndex);
        this.headerType = bitReader.readInt32(2);
        if (this.headerType != 0) {
            throw new TikaException(String.format(Locale.US, "Failed to get the StreamObjectHeaderStart16bit header type value, expect value %s, but actual value is %s", 0, this.headerType));
        }
        this.compound = bitReader.readInt32(1);
        int typeValue = bitReader.readInt32(6);
        this.type = StreamObjectTypeHeaderStart.fromIntVal(typeValue);
        if (this.type == null) {
            throw new TikaException(String.format(Locale.US, "Failed to get the StreamObjectHeaderStart16bit type value, the value %s is not defined", typeValue));
        }
        if (StreamObject.getCompoundTypes().contains((Object)this.type) && this.compound != 1) {
            throw new TikaException(String.format(Locale.US, "Failed to parse the StreamObjectHeaderStart16bit header. If the type value is %s then the compound value should 1, but actual value is 0", typeValue));
        }
        this.length = bitReader.readInt32(7);
        if (this.length > 127) {
            throw new TikaException("16-bit Stream Object Header Start, Length (7-bits): A 7-bit unsigned integer that specifies the length in bytes for additional data (if any). If the length is more than 127 bytes, a 32-bit stream object header start MUST be used.");
        }
        return 2;
    }
}

