/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.util.mail;

import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import net.fortuna.ical4j.data.CalendarOutputter;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.parameter.CuType;
import net.fortuna.ical4j.model.parameter.PartStat;
import net.fortuna.ical4j.model.parameter.Role;
import net.fortuna.ical4j.model.parameter.Rsvp;
import net.fortuna.ical4j.model.parameter.XParameter;
import net.fortuna.ical4j.model.property.Attendee;
import net.fortuna.ical4j.model.property.Created;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Method;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Sequence;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.immutable.ImmutableCalScale;
import net.fortuna.ical4j.model.property.immutable.ImmutableMethod;
import net.fortuna.ical4j.model.property.immutable.ImmutableStatus;
import net.fortuna.ical4j.model.property.immutable.ImmutableTransp;
import net.fortuna.ical4j.model.property.immutable.ImmutableVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcalHandler {
    private static final Logger log = LoggerFactory.getLogger(IcalHandler.class);
    public static final TimeZoneRegistry TZ_REGISTRY = TimeZoneRegistryFactory.getInstance().createRegistry();
    private final Calendar icsCalendar;
    private TimeZone timeZone;
    private VEvent meeting;
    private List<Property> meetingProperties = new ArrayList<Property>();
    private Method method;
    public static final Method ICAL_METHOD_REQUEST = ImmutableMethod.REQUEST;
    public static final Method ICAL_METHOD_CANCEL = ImmutableMethod.CANCEL;
    public static final Method ICAL_METHOD_REFRESH = ImmutableMethod.REFRESH;

    public IcalHandler(Method method) {
        this.method = method;
        log.debug("Icalhandler method type : {}", (Object)method);
        this.icsCalendar = new Calendar(new PropertyList(List.of(new ProdId("-//Apache Openmeetings//OM Calendar//EN"), ImmutableVersion.VERSION_2_0, ImmutableCalScale.GREGORIAN, method)), new ComponentList());
    }

    public IcalHandler createVEvent(ZonedDateTime start, ZonedDateTime end, String name) {
        this.timeZone = TZ_REGISTRY.getTimeZone(start.getZone().getId());
        if (this.timeZone == null) {
            throw new NoSuchElementException("Unable to get time zone by id provided: " + String.valueOf(start.getZone()));
        }
        this.meeting = new VEvent((Temporal)start, (Temporal)end, name);
        this.meetingProperties.addAll(this.meeting.getProperties());
        this.meetingProperties.addAll(List.of(ImmutableTransp.OPAQUE, ImmutableStatus.VEVENT_CONFIRMED));
        return this;
    }

    public IcalHandler setCreated(ZonedDateTime date) {
        this.meetingProperties.add((Property)new Created(date.toInstant()));
        return this;
    }

    public IcalHandler setModified(ZonedDateTime date) {
        this.meetingProperties.add((Property)new LastModified((date == null ? ZonedDateTime.now() : date).toInstant()));
        return this;
    }

    public IcalHandler setDescription(String description) {
        this.meetingProperties.add((Property)new Description(description));
        return this;
    }

    public IcalHandler setLocation(String location) {
        this.meetingProperties.add((Property)new Location(location));
        return this;
    }

    public IcalHandler setSequence(int seq) {
        this.meetingProperties.add((Property)new Sequence(seq));
        return this;
    }

    public IcalHandler setUid(String uid) {
        this.meetingProperties.add((Property)new Uid(uid));
        return this;
    }

    private static URI getMailto(String email) {
        return URI.create("mailto:" + email);
    }

    public IcalHandler addOrganizer(String email, String name) {
        this.meetingProperties.add((Property)new Organizer(new ParameterList(List.of(new Cn(name))), IcalHandler.getMailto(email)));
        return this;
    }

    public IcalHandler addAttendee(String email, String display, boolean chair) {
        ArrayList<Cn> params = new ArrayList<Cn>(List.of(CuType.INDIVIDUAL, chair ? Role.CHAIR : Role.REQ_PARTICIPANT, new XParameter("X-NUM-GUESTS", "0"), new Cn(display)));
        if (ImmutableMethod.CANCEL.equals((Object)this.method)) {
            params.add((Cn)PartStat.DECLINED);
        } else {
            params.add((Cn)(chair ? PartStat.ACCEPTED : PartStat.NEEDS_ACTION));
            params.add((Cn)Rsvp.TRUE);
        }
        this.meetingProperties.add((Property)new Attendee(new ParameterList(params), IcalHandler.getMailto(email)));
        return this;
    }

    public IcalHandler build() {
        this.meeting.setPropertyList(new PropertyList(this.meetingProperties));
        this.icsCalendar.setComponentList(new ComponentList(List.of(this.timeZone.getVTimeZone(), this.meeting)));
        return this;
    }

    public Method getMethod() {
        return this.method;
    }

    public void toFile(String inFilerPath) throws Exception {
        Object filerPath = inFilerPath.endsWith(".ics") ? inFilerPath : inFilerPath + ".ics";
        try (FileOutputStream fout = new FileOutputStream((String)filerPath);){
            CalendarOutputter outputter = new CalendarOutputter();
            outputter.output(this.icsCalendar, (OutputStream)fout);
        }
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        CalendarOutputter outputter = new CalendarOutputter();
        outputter.output(this.icsCalendar, (OutputStream)bout);
        return bout.toByteArray();
    }

    public String toString() {
        if (this.icsCalendar == null) {
            return "";
        }
        try {
            return new String(this.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            log.error("Unexpected error", (Throwable)e);
            return "";
        }
    }
}

