/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.dom.FieldParser;
import org.apache.james.mime4j.dom.field.ContentLanguageField;
import org.apache.james.mime4j.field.AbstractField;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.stream.ParserCursor;
import org.apache.james.mime4j.stream.RawField;
import org.apache.james.mime4j.stream.RawFieldParser;
import org.apache.james.mime4j.util.ByteSequence;
import org.apache.james.mime4j.util.ContentUtil;

public class ContentLanguageFieldLenientImpl
extends AbstractField
implements ContentLanguageField {
    private static final int COMMA = 44;
    private static final BitSet DELIM = RawFieldParser.INIT_BITSET((int[])new int[]{44});
    private boolean parsed = false;
    private List<String> languages;
    public static final FieldParser<ContentLanguageField> PARSER = new FieldParser<ContentLanguageField>(){

        @Override
        public ContentLanguageField parse(Field rawField, DecodeMonitor monitor) {
            return new ContentLanguageFieldLenientImpl(rawField, monitor);
        }
    };

    ContentLanguageFieldLenientImpl(Field rawField, DecodeMonitor monitor) {
        super(rawField, monitor);
    }

    private void parse() {
        this.parsed = true;
        this.languages = new ArrayList<String>();
        RawField f = this.getRawField();
        ByteSequence buf = f.getRaw();
        int pos = f.getDelimiterIdx() + 1;
        if (buf == null) {
            String body = f.getBody();
            if (body == null) {
                return;
            }
            buf = ContentUtil.encode((CharSequence)body);
            pos = 0;
        }
        RawFieldParser parser = RawFieldParser.DEFAULT;
        ParserCursor cursor = new ParserCursor(pos, buf.length());
        while (true) {
            String token;
            if ((token = parser.parseToken(buf, cursor, DELIM)).length() > 0) {
                this.languages.add(token);
            }
            if (cursor.atEnd()) break;
            pos = cursor.getPos();
            if (buf.byteAt(pos) != 44) continue;
            cursor.updatePos(pos + 1);
        }
    }

    @Override
    public List<String> getLanguages() {
        if (!this.parsed) {
            this.parse();
        }
        return new ArrayList<String>(this.languages);
    }
}

