/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.plugins.datepicker;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.JQueryPluginResourceReference;
import org.apache.wicket.util.lang.Args;
import org.wicketstuff.jquery.core.JQueryBehavior;
import org.wicketstuff.jquery.core.JQueryEvent;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.jquery.core.ajax.IJQueryAjaxAware;
import org.wicketstuff.jquery.core.ajax.JQueryAjaxBehavior;
import org.wicketstuff.jquery.core.utils.RequestCycleUtils;
import org.wicketstuff.jquery.ui.plugins.datepicker.DateRange;
import org.wicketstuff.jquery.ui.plugins.datepicker.IRangeDatePickerListener;

@Deprecated
public class RangeDatePickerBehavior
extends JQueryBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "DatePicker";
    private final IRangeDatePickerListener listener;
    private JQueryAjaxBehavior onRangeChangeAjaxBehavior;

    public RangeDatePickerBehavior(String selector, IRangeDatePickerListener listener) {
        this(selector, new Options(), listener);
    }

    public RangeDatePickerBehavior(String selector, Options options, IRangeDatePickerListener listener) {
        super(selector, METHOD, options);
        this.listener = (IRangeDatePickerListener)Args.notNull((Object)listener, (String)"listener");
        this.add((ResourceReference)new CssResourceReference(RangeDatePickerBehavior.class, "css/base.css"));
        this.add((ResourceReference)new CssResourceReference(RangeDatePickerBehavior.class, "css/clean.css"));
        this.add((ResourceReference)new JQueryPluginResourceReference(RangeDatePickerBehavior.class, "js/datepicker.js"));
    }

    public void bind(Component component) {
        super.bind(component);
        this.onRangeChangeAjaxBehavior = this.newOnRangeChangeAjaxBehavior(this);
        component.add(new Behavior[]{this.onRangeChangeAjaxBehavior});
    }

    public void onConfigure(Component component) {
        this.setOption("onRangeChange", this.onRangeChangeAjaxBehavior.getCallbackFunction());
        super.onConfigure(component);
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof DateChangeEvent) {
            DateChangeEvent ev = (DateChangeEvent)event;
            this.listener.onValueChanged(target, new DateRange(ev.getStart(), ev.getEnd()));
        }
    }

    private JQueryAjaxBehavior newOnRangeChangeAjaxBehavior(IJQueryAjaxAware source) {
        return new OnRangeChangeAjaxBehavior(source);
    }

    protected static class DateChangeEvent
    extends JQueryEvent {
        private final long start;
        private final long end;

        public DateChangeEvent() {
            long startTime = RequestCycleUtils.getQueryParameterValue((String)"startTime").toLong();
            int startOffset = RequestCycleUtils.getQueryParameterValue((String)"startOffset").toInt(0) * 60 * 1000;
            this.start = startTime - (long)startOffset;
            long endTime = RequestCycleUtils.getQueryParameterValue((String)"endTime").toLong();
            int endOffset = RequestCycleUtils.getQueryParameterValue((String)"endOffset").toInt(0) * 60 * 1000;
            this.end = endTime - (long)endOffset;
        }

        public long getStart() {
            return this.start;
        }

        public long getEnd() {
            return this.end;
        }
    }

    protected static class OnRangeChangeAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnRangeChangeAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"dates"), CallbackParameter.context((String)"el"), CallbackParameter.resolved((String)"startTime", (String)"dates[0].getTime()"), CallbackParameter.resolved((String)"startOffset", (String)"dates[0].getTimezoneOffset()"), CallbackParameter.resolved((String)"endTime", (String)"dates[1].getTime()"), CallbackParameter.resolved((String)"endOffset", (String)"dates[1].getTimezoneOffset()")};
        }

        protected JQueryEvent newEvent() {
            return new DateChangeEvent();
        }
    }
}

