/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.support.SQLErrorCodeSQLExceptionTranslator;
import org.springframework.jdbc.support.SQLExceptionSubclassTranslator;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.lang.Nullable;

public class JdbcTransactionManager
extends DataSourceTransactionManager {
    @Nullable
    private volatile SQLExceptionTranslator exceptionTranslator;
    private boolean lazyInit = true;

    public JdbcTransactionManager() {
    }

    public JdbcTransactionManager(DataSource dataSource) {
        this();
        this.setDataSource(dataSource);
        this.afterPropertiesSet();
    }

    public void setDatabaseProductName(String dbName) {
        this.exceptionTranslator = SQLErrorCodeSQLExceptionTranslator.hasUserProvidedErrorCodesFile() ? new SQLErrorCodeSQLExceptionTranslator(dbName) : new SQLExceptionSubclassTranslator();
    }

    public void setExceptionTranslator(SQLExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLExceptionTranslator getExceptionTranslator() {
        SQLExceptionTranslator exceptionTranslator = this.exceptionTranslator;
        if (exceptionTranslator != null) {
            return exceptionTranslator;
        }
        JdbcTransactionManager jdbcTransactionManager = this;
        synchronized (jdbcTransactionManager) {
            exceptionTranslator = this.exceptionTranslator;
            if (exceptionTranslator == null) {
                exceptionTranslator = SQLErrorCodeSQLExceptionTranslator.hasUserProvidedErrorCodesFile() ? new SQLErrorCodeSQLExceptionTranslator(this.obtainDataSource()) : new SQLExceptionSubclassTranslator();
                this.exceptionTranslator = exceptionTranslator;
            }
            return exceptionTranslator;
        }
    }

    public void setLazyInit(boolean lazyInit) {
        this.lazyInit = lazyInit;
    }

    public boolean isLazyInit() {
        return this.lazyInit;
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        if (!this.isLazyInit()) {
            this.getExceptionTranslator();
        }
    }

    @Override
    protected RuntimeException translateException(String task, SQLException ex) {
        DataAccessException dae = this.getExceptionTranslator().translate(task, null, ex);
        if (dae != null) {
            return dae;
        }
        return super.translateException(task, ex);
    }
}

