/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.query;

import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.query.Query;
import com.hazelcast.map.impl.query.QueryRunner;
import com.hazelcast.map.impl.query.Result;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.query.impl.IndexRegistry;
import com.hazelcast.spi.impl.operationservice.PartitionAwareOperation;
import com.hazelcast.spi.impl.operationservice.ReadonlyOperation;
import java.io.IOException;

public class QueryPartitionOperation
extends MapOperation
implements PartitionAwareOperation,
ReadonlyOperation {
    private Query query;
    private Result result;

    public QueryPartitionOperation() {
    }

    public QueryPartitionOperation(Query query) {
        super(query.getMapName());
        this.query = query;
    }

    @Override
    protected void runInternal() {
        QueryRunner queryRunner = this.mapServiceContext.getMapQueryRunner(this.getName());
        this.result = queryRunner.runPartitionIndexOrPartitionScanQueryOnGivenOwnedPartition(this.query, this.getPartitionId());
        IndexRegistry indexRegistry = this.mapContainer.getGlobalIndexRegistry();
        if (indexRegistry != null) {
            indexRegistry.getIndexesStats().incrementQueryCount();
        }
    }

    @Override
    public Object getResponse() {
        return this.result;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.query);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.query = (Query)in.readObject();
    }

    @Override
    public int getClassId() {
        return 57;
    }
}

