/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.submitjob.clientside.validator;

import com.hazelcast.jet.JetException;
import com.hazelcast.jet.impl.SubmitJobParameters;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;

public final class SubmitJobParametersValidator {
    private SubmitJobParametersValidator() {
    }

    public static void validateJarOnClient(SubmitJobParameters parameterObject) throws IOException {
        if (parameterObject.isJarOnMember()) {
            throw new JetException("SubmitJobParameters is configured for jar on member");
        }
        Path jarPath = parameterObject.getJarPath();
        SubmitJobParametersValidator.validateJarPathNotNull(jarPath);
        SubmitJobParametersValidator.validateFileSizeIsNotZero(jarPath);
        SubmitJobParametersValidator.validateFileExtension(jarPath);
        SubmitJobParametersValidator.validateJobParameters(parameterObject.getJobParameters());
    }

    public static void validateJarOnMember(SubmitJobParameters parameterObject) {
        if (!parameterObject.isJarOnMember()) {
            throw new JetException("SubmitJobParameters is configured for jar on client");
        }
        Path jarPath = parameterObject.getJarPath();
        SubmitJobParametersValidator.validateJarPathNotNull(jarPath);
        SubmitJobParametersValidator.validateFileExtension(jarPath);
        SubmitJobParametersValidator.validateJobParameters(parameterObject.getJobParameters());
    }

    static void validateJarPathNotNull(Path jarPath) {
        if (Objects.isNull(jarPath)) {
            throw new JetException("jarPath can not be null");
        }
    }

    static void validateFileExtension(Path jarPath) {
        String fileName = jarPath.getFileName().toString();
        if (!fileName.endsWith(".jar")) {
            throw new JetException("File name extension should be .jar");
        }
    }

    static void validateFileSizeIsNotZero(Path jarPath) throws IOException {
        long jarSize = Files.size(jarPath);
        if (jarSize == 0L) {
            throw new JetException("Jar size can not be 0");
        }
    }

    static void validateJobParameters(List<String> jobParameters) {
        if (Objects.isNull(jobParameters)) {
            throw new JetException("jobParameters can not be null");
        }
    }
}

