/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl.connector;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.jet.config.ProcessingGuarantee;
import com.hazelcast.jet.core.Inbox;
import com.hazelcast.jet.core.Outbox;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.impl.connector.XaSinkProcessorBase;
import com.hazelcast.jet.impl.util.Util;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.XAConnection;
import jakarta.jms.XASession;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class WriteJmsP<T>
extends XaSinkProcessorBase {
    private static final int PREFERRED_LOCAL_PARALLELISM = 1;
    private final Connection connection;
    private Session session;
    private final String destinationName;
    private final BiFunctionEx<? super Session, ? super T, ? extends Message> messageFn;
    private final boolean isTopic;
    private MessageProducer producer;

    private WriteJmsP(Connection connection, String destinationName, boolean exactlyOnce, BiFunctionEx<? super Session, ? super T, ? extends Message> messageFn, boolean isTopic) {
        super(exactlyOnce ? ProcessingGuarantee.EXACTLY_ONCE : ProcessingGuarantee.AT_LEAST_ONCE);
        this.connection = connection;
        this.destinationName = destinationName;
        this.messageFn = messageFn;
        this.isTopic = isTopic;
    }

    @Override
    public void init(@Nonnull Outbox outbox, @Nonnull Processor.Context context) throws Exception {
        super.init(outbox, context);
        if (this.snapshotUtility.usesTransactionLifecycle()) {
            XASession xaSession = ((XAConnection)this.connection).createXASession();
            this.setXaResource(xaSession.getXAResource());
            this.session = xaSession;
        } else {
            this.session = this.connection.createSession(true, 0);
        }
        Topic destination = this.isTopic ? this.session.createTopic(this.destinationName) : this.session.createQueue(this.destinationName);
        this.producer = this.session.createProducer((Destination)destination);
    }

    @Override
    public void process(int ordinal, @Nonnull Inbox inbox) {
        if (this.snapshotUtility.activeTransaction() == null) {
            return;
        }
        try {
            Object item;
            while ((item = inbox.poll()) != null) {
                Object castItem = item;
                Message msg = this.messageFn.apply((Session)((Session)this.session), (Session)castItem);
                this.producer.send(msg);
            }
            if (!this.snapshotUtility.usesTransactionLifecycle()) {
                this.session.commit();
            }
        }
        catch (JMSException e) {
            throw ExceptionUtil.sneakyThrow(e);
        }
    }

    public static <T> ProcessorMetaSupplier supplier(String destinationName, boolean exactlyOnce, SupplierEx<? extends Connection> newConnectionFn, BiFunctionEx<? super Session, T, ? extends Message> messageFn, boolean isTopic) {
        Util.checkSerializable(newConnectionFn, "newConnectionFn");
        Util.checkSerializable(messageFn, "messageFn");
        return ProcessorMetaSupplier.of(1, new Supplier<T>(destinationName, exactlyOnce, newConnectionFn, messageFn, isTopic));
    }

    private static final class Supplier<T>
    implements ProcessorSupplier {
        private static final long serialVersionUID = 1L;
        private final SupplierEx<? extends Connection> newConnectionFn;
        private final String destinationName;
        private final boolean exactlyOnce;
        private final BiFunctionEx<? super Session, ? super T, ? extends Message> messageFn;
        private final boolean isTopic;
        private transient Connection connection;

        private Supplier(String destinationName, boolean exactlyOnce, SupplierEx<? extends Connection> newConnectionFn, BiFunctionEx<? super Session, ? super T, ? extends Message> messageFn, boolean isTopic) {
            this.destinationName = destinationName;
            this.exactlyOnce = exactlyOnce;
            this.newConnectionFn = newConnectionFn;
            this.messageFn = messageFn;
            this.isTopic = isTopic;
        }

        @Override
        public void init(@Nonnull ProcessorSupplier.Context ignored) throws Exception {
            this.connection = this.newConnectionFn.get();
            this.connection.start();
        }

        @Override
        @Nonnull
        public Collection<? extends Processor> get(int count) {
            SupplierEx<Processor> supplier = () -> new WriteJmsP(this.connection, this.destinationName, this.exactlyOnce, this.messageFn, this.isTopic);
            return Stream.generate(supplier).limit(count).collect(Collectors.toList());
        }

        @Override
        public void close(Throwable error) throws Exception {
            if (this.connection != null) {
                this.connection.close();
            }
        }
    }
}

