/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.core;

import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.util.Preconditions;
import javax.annotation.Nonnull;

public interface WatermarkPolicy {
    public void reportEvent(long var1);

    public long getCurrentWatermark();

    @Nonnull
    public static SupplierEx<WatermarkPolicy> limitingLag(final long lag) {
        Preconditions.checkNotNegative(lag, "lag must not be negative");
        return () -> new WatermarkPolicy(){
            private long wm = Long.MIN_VALUE;

            @Override
            public void reportEvent(long timestamp) {
                if (timestamp >= Long.MIN_VALUE + lag) {
                    this.wm = Math.max(this.wm, timestamp - lag);
                }
            }

            @Override
            public long getCurrentWatermark() {
                return this.wm;
            }
        };
    }

    @Nonnull
    public static SupplierEx<WatermarkPolicy> limitingRealTimeLag(final long lag) {
        Preconditions.checkNotNegative(lag, "lag must not be negative");
        return () -> new WatermarkPolicy(){

            @Override
            public void reportEvent(long timestamp) {
            }

            @Override
            public long getCurrentWatermark() {
                return System.currentTimeMillis() - lag;
            }
        };
    }
}

