/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util.phonehome;

import com.hazelcast.internal.util.phonehome.Metric;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MetricsCollectionContext {
    private final Map<String, String> parameters = new LinkedHashMap<String, String>();
    private String query;

    Map<String, String> getParameters() {
        return this.parameters;
    }

    public void collect(@Nonnull Metric metric, @Nonnull Object value) {
        String parameter = metric.getQueryParameter();
        String valueStr = value.toString();
        if (this.parameters.containsKey(parameter)) {
            throw new IllegalArgumentException("Parameter " + parameter + " is already added");
        }
        this.parameters.put(parameter, valueStr);
        this.query = null;
    }

    String getQueryString() {
        if (this.query == null) {
            this.query = this.parameters.entrySet().stream().collect(StringBuilder::new, (sb, e) -> (sb.isEmpty() ? sb : sb.append('&')).append((String)e.getKey()).append('=').append(URLEncoder.encode((String)e.getValue(), StandardCharsets.UTF_8)), StringBuilder::append).toString();
        }
        return this.query;
    }
}

