/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.ascii.memcache;

import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.memcache.MemcacheEntry;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;

public final class EntryConverter {
    private final TextCommandService textCommandService;
    private final ILogger logger;

    public EntryConverter(TextCommandService textCommandService, ILogger logger) {
        this.textCommandService = textCommandService;
        this.logger = logger;
    }

    public MemcacheEntry toEntry(String key, Object value) {
        if (value == null) {
            return null;
        }
        MemcacheEntry entry = null;
        if (value instanceof MemcacheEntry) {
            MemcacheEntry memcacheEntry;
            entry = memcacheEntry = (MemcacheEntry)value;
        } else if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            entry = new MemcacheEntry(key, bytes, 0);
        } else if (value instanceof String) {
            String string = (String)value;
            entry = new MemcacheEntry(key, StringUtil.stringToBytes(string), 0);
        } else {
            try {
                entry = new MemcacheEntry(key, this.textCommandService.toByteArray(value), 0);
            }
            catch (Exception e) {
                this.logger.warning(e);
            }
        }
        return entry;
    }
}

