/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config.matcher;

import com.hazelcast.config.ConfigPatternMatcher;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.config.ConfigUtils;

public class WildcardConfigPatternMatcher
implements ConfigPatternMatcher {
    @Override
    public String matches(Iterable<String> configPatterns, String itemName) throws InvalidConfigurationException {
        String candidate = null;
        for (String pattern : configPatterns) {
            if (!this.matches(pattern, itemName)) continue;
            if (candidate != null) {
                throw ConfigUtils.createAmbiguousConfigurationException(itemName, candidate, pattern);
            }
            candidate = pattern;
        }
        return candidate;
    }

    public boolean matches(String pattern, String itemName) {
        int index = pattern.indexOf(42);
        if (index == -1) {
            return itemName.equals(pattern);
        }
        String firstPart = pattern.substring(0, index);
        if (!itemName.startsWith(firstPart)) {
            return false;
        }
        String secondPart = pattern.substring(index + 1);
        if (!itemName.endsWith(secondPart)) {
            return false;
        }
        return itemName.length() + 1 >= pattern.length();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return super.hashCode();
    }
}

