/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.config.vector.VectorIndexConfig;

public final class VectorIndexConfigCodec {
    private static final int METRIC_FIELD_OFFSET = 0;
    private static final int DIMENSION_FIELD_OFFSET = 4;
    private static final int MAX_DEGREE_FIELD_OFFSET = 8;
    private static final int EF_CONSTRUCTION_FIELD_OFFSET = 12;
    private static final int USE_DEDUPLICATION_FIELD_OFFSET = 16;
    private static final int INITIAL_FRAME_SIZE = 17;

    private VectorIndexConfigCodec() {
    }

    public static void encode(ClientMessage clientMessage, VectorIndexConfig vectorIndexConfig) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[17]);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, vectorIndexConfig.getMetric());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 4, vectorIndexConfig.getDimension());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 8, vectorIndexConfig.getMaxDegree());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, vectorIndexConfig.getEfConstruction());
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 16, vectorIndexConfig.isUseDeduplication());
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, vectorIndexConfig.getName(), StringCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static VectorIndexConfig decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        int metric = FixedSizeTypesCodec.decodeInt(initialFrame.content, 0);
        int dimension = FixedSizeTypesCodec.decodeInt(initialFrame.content, 4);
        int maxDegree = FixedSizeTypesCodec.decodeInt(initialFrame.content, 8);
        int efConstruction = FixedSizeTypesCodec.decodeInt(initialFrame.content, 12);
        boolean useDeduplication = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 16);
        String name = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator);
        return CustomTypeFactory.createVectorIndexConfig(name, metric, dimension, maxDegree, efConstruction, useDeduplication);
    }
}

