/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config.impl;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.impl.AbstractQueryCacheConfigBuilderHelper;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.internal.config.DomConfigHelper;
import com.hazelcast.query.impl.IndexUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

final class QueryCacheYamlConfigBuilderHelper
extends AbstractQueryCacheConfigBuilderHelper {
    QueryCacheYamlConfigBuilderHelper() {
        super(true);
    }

    QueryCacheYamlConfigBuilderHelper(boolean strict) {
        super(true, strict);
    }

    @Override
    public void handleQueryCache(ClientConfig clientConfig, Node node) {
        for (Node queryCacheNode : DomConfigHelper.childElements(node)) {
            this.handleQueryCacheNode(clientConfig, queryCacheNode);
        }
    }

    @Override
    protected String getCacheName(Node queryCacheNode) {
        return queryCacheNode.getNodeName();
    }

    @Override
    protected String getCacheMapName(NamedNodeMap attrs) {
        return this.getTextContent(this.getNamedItemNode(attrs, "map-name"));
    }

    @Override
    protected void handleEntryListeners(QueryCacheConfig queryCacheConfig, Node childNode) {
        for (Node listenerNode : DomConfigHelper.childElements(childNode)) {
            boolean incValue = DomConfigHelper.getBooleanValue(this.getTextContent(this.getNamedItemNode(listenerNode, "include-value")));
            boolean local = DomConfigHelper.getBooleanValue(this.getTextContent(this.getNamedItemNode(listenerNode, "local")));
            String listenerClass = this.getTextContent(this.getNamedItemNode(listenerNode, "class-name"));
            queryCacheConfig.addEntryListenerConfig(new EntryListenerConfig(listenerClass, local, incValue));
        }
    }

    @Override
    protected void queryCachePredicateHandler(Node childNode, QueryCacheConfig queryCacheConfig) {
        Node classNameNode = this.getNamedItemNode(childNode, "class-name");
        Node sqlNode = this.getNamedItemNode(childNode, "sql");
        if (classNameNode != null && sqlNode != null) {
            throw new InvalidConfigurationException("Both class-name and sql is defined for the predicate of map " + childNode.getParentNode().getParentNode().getNodeName());
        }
        if (classNameNode == null && sqlNode == null) {
            throw new InvalidConfigurationException("Either class-name and sql must be defined for the predicate of map " + childNode.getParentNode().getParentNode().getNodeName());
        }
        PredicateConfig predicateConfig = new PredicateConfig();
        if (classNameNode != null) {
            predicateConfig.setClassName(this.getTextContent(classNameNode));
        } else if (sqlNode != null) {
            predicateConfig.setSql(this.getTextContent(sqlNode));
        }
        queryCacheConfig.setPredicateConfig(predicateConfig);
    }

    @Override
    protected void queryCacheIndexesHandle(Node childNode, QueryCacheConfig queryCacheConfig) {
        for (Node indexNode : DomConfigHelper.childElements(childNode)) {
            IndexConfig indexConfig = IndexUtils.getIndexConfigFromYaml(indexNode, this.domLevel3, this.strict);
            queryCacheConfig.addIndexConfig(indexConfig);
        }
    }
}

