/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.jquery.ui.form.button;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.jquery.core.panel.FormSubmittingPanel;
import org.wicketstuff.jquery.ui.form.button.AjaxButton;
import org.wicketstuff.jquery.ui.widget.dialog.AbstractDialog;
import org.wicketstuff.jquery.ui.widget.dialog.DialogButton;
import org.wicketstuff.jquery.ui.widget.dialog.DialogButtons;
import org.wicketstuff.jquery.ui.widget.dialog.DialogIcon;
import org.wicketstuff.jquery.ui.widget.dialog.MessageDialog;

public abstract class ConfirmButton
extends FormSubmittingPanel<String> {
    private static final long serialVersionUID = 1L;
    private final IModel<String> labelModel;
    private final IModel<String> titleModel;

    public ConfirmButton(String id, String label, String title, String message) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)label)), (IModel<String>)Model.of((Serializable)((Object)title)), (IModel<String>)Model.of((Serializable)((Object)message)));
    }

    public ConfirmButton(String id, IModel<String> label, IModel<String> title, IModel<String> message) {
        super(id, message);
        this.labelModel = label;
        this.titleModel = title;
    }

    protected void onInitialize() {
        super.onInitialize();
        AbstractDialog<?> dialog = this.newDialog("dialog", this.titleModel, (IModel<String>)this.getModel());
        this.add(new Component[]{dialog});
        AjaxButton button = this.newAjaxButton("button", dialog);
        this.add(new Component[]{button});
        button.add(new Component[]{new Label("label", this.labelModel).setRenderBodyOnly(true)});
    }

    protected void onDetach() {
        super.onDetach();
        this.labelModel.detach();
        this.titleModel.detach();
    }

    protected String getIcon() {
        return "ui-icon-alert";
    }

    protected AbstractDialog<?> newDialog(String id, IModel<String> title, IModel<String> message) {
        return new MessageDialog(id, title, message, DialogButtons.OK_CANCEL, DialogIcon.WARN){
            private static final long serialVersionUID = 1L;

            @Override
            public void onClose(IPartialPageRequestHandler handler, DialogButton button) {
                if (button != null && button.match("OK")) {
                    ConfirmButton.this.submit(handler);
                }
            }
        };
    }

    protected AjaxButton newAjaxButton(String id, final AbstractDialog<?> dialog) {
        return new AjaxButton(id){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onInitialize() {
                super.onInitialize();
                this.setDefaultFormProcessing(false);
            }

            @Override
            protected String getIcon() {
                return ConfirmButton.this.getIcon();
            }

            protected void onSubmit(AjaxRequestTarget target) {
                dialog.open((IPartialPageRequestHandler)target);
            }
        };
    }
}

