/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.office;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.core.office.AbstractOfficeManagerPool;
import org.jodconverter.core.office.InstalledOfficeManagerHolder;
import org.jodconverter.core.office.OfficeManager;
import org.jodconverter.core.office.OfficeUtils;
import org.jodconverter.core.util.AssertUtils;
import org.jodconverter.local.office.ExternalOfficeConnectionManager;
import org.jodconverter.local.office.ExternalOfficeManagerPoolEntry;
import org.jodconverter.local.office.LocalOfficeUtils;
import org.jodconverter.local.office.OfficeConnection;
import org.jodconverter.local.office.OfficeUrl;

public final class ExternalOfficeManager
extends AbstractOfficeManagerPool<ExternalOfficeManagerPoolEntry> {
    static final String DEFAULT_HOSTNAME = "127.0.0.1";
    static final boolean DEFAULT_CONNECT_ON_START = true;
    static final long DEFAULT_CONNECT_TIMEOUT = 120000L;
    static final long DEFAULT_CONNECT_RETRY_INTERVAL = 250L;
    static final boolean DEFAULT_CONNECT_FAIL_FAST = false;
    static final long MAX_CONNECT_RETRY_INTERVAL = 10000L;
    static final int DEFAULT_MAX_TASKS_PER_CONNECTION = 1000;

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public static @NonNull ExternalOfficeManager make() {
        return ExternalOfficeManager.builder().build();
    }

    public static @NonNull ExternalOfficeManager install() {
        return ((Builder)ExternalOfficeManager.builder().install()).build();
    }

    private ExternalOfficeManager(List<OfficeUrl> officeUrls, File workingDir, boolean connectOnStart, long connectTimeout, long connectRetryInterval, boolean connectFailFast, int maxTasksPerConnection, long taskExecutionTimeout, long taskQueueTimeout) {
        super(officeUrls.size(), workingDir, taskQueueTimeout);
        this.setEntries(officeUrls.stream().map(officeUrl -> new ExternalOfficeManagerPoolEntry(connectOnStart, maxTasksPerConnection, taskExecutionTimeout, new ExternalOfficeConnectionManager(connectTimeout, connectRetryInterval, connectFailFast, new OfficeConnection((OfficeUrl)officeUrl)))).collect(Collectors.toList()));
    }

    public static final class Builder
    extends AbstractOfficeManagerPool.AbstractOfficeManagerPoolBuilder<Builder> {
        private List<String> pipeNames;
        private String hostName = "127.0.0.1";
        private List<Integer> portNumbers;
        private List<String> websocketUrls;
        private Boolean connectOnStart = true;
        private long connectTimeout = 120000L;
        private Long connectRetryInterval = 250L;
        private boolean connectFailFast = false;
        private int maxTasksPerConnection = 1000;

        private Builder() {
        }

        public @NonNull ExternalOfficeManager build() {
            OfficeUtils.validateWorkingDir((File)this.workingDir);
            ExternalOfficeManager manager = new ExternalOfficeManager(LocalOfficeUtils.buildOfficeUrls(this.hostName, this.portNumbers, this.pipeNames, this.websocketUrls), this.workingDir, this.connectOnStart, this.connectTimeout, this.connectRetryInterval, this.connectFailFast, this.maxTasksPerConnection, this.taskExecutionTimeout, this.taskQueueTimeout);
            if (this.install) {
                InstalledOfficeManagerHolder.setInstance((OfficeManager)manager);
            }
            return manager;
        }

        public @NonNull Builder hostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public @NonNull Builder pipeNames(String ... pipeNames) {
            if (pipeNames != null && pipeNames.length != 0) {
                this.pipeNames = Arrays.asList(pipeNames);
            }
            return this;
        }

        public @NonNull Builder portNumbers(int ... portNumbers) {
            if (portNumbers != null && portNumbers.length != 0) {
                this.portNumbers = Arrays.stream(portNumbers).boxed().collect(Collectors.toList());
            }
            return this;
        }

        public @NonNull Builder websocketUrls(String ... websocketUrls) {
            if (websocketUrls != null && websocketUrls.length != 0) {
                this.websocketUrls = Arrays.asList(websocketUrls);
            }
            return this;
        }

        public @NonNull Builder connectOnStart(@Nullable Boolean connectOnStart) {
            if (connectOnStart != null) {
                this.connectOnStart = connectOnStart;
            }
            return this;
        }

        public @NonNull Builder connectTimeout(@Nullable Long connectTimeout) {
            if (connectTimeout != null) {
                AssertUtils.isTrue((connectTimeout >= 0L ? 1 : 0) != 0, (String)String.format("connectTimeout %s must be greater than or equal to 0", connectTimeout));
                this.connectTimeout = connectTimeout;
            }
            return this;
        }

        public @NonNull Builder connectRetryInterval(@Nullable Long connectRetryInterval) {
            if (connectRetryInterval != null) {
                AssertUtils.isTrue((connectRetryInterval >= 0L && connectRetryInterval <= 10000L ? 1 : 0) != 0, (String)String.format("retryInterval %s must be in the inclusive range of %s to %s", connectRetryInterval, 0, 10000L));
                this.connectRetryInterval = connectRetryInterval;
            }
            return this;
        }

        public @NonNull Builder connectFailFast(@Nullable Boolean connectFailFast) {
            if (connectFailFast != null) {
                this.connectFailFast = connectFailFast;
            }
            return this;
        }

        public @NonNull Builder maxTasksPerConnection(@Nullable Integer maxTasksPerConnection) {
            if (maxTasksPerConnection != null) {
                AssertUtils.isTrue((maxTasksPerConnection >= 0 ? 1 : 0) != 0, (String)String.format("maxTasksPerConnection %s must be greater than or equal to 0", maxTasksPerConnection));
                this.maxTasksPerConnection = maxTasksPerConnection;
            }
            return this;
        }
    }
}

