/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.time.Instants;

public class HttpHeaderCollection {
    private final Map<HeaderKey, List<Object>> headers = new HashMap<HeaderKey, List<Object>>();
    private static final String[] NO_VALUES = new String[0];

    private void internalAdd(String name, Object object) {
        HeaderKey key = new HeaderKey(name);
        List<Object> values = this.headers.get(key);
        if (values == null) {
            values = new ArrayList<Object>();
            this.headers.put(key, values);
        }
        values.add(object);
    }

    public void setHeader(String name, String value) {
        this.removeHeader(name);
        this.addHeader(name, value);
    }

    public void addHeader(String name, String value) {
        value = ((String)Args.notNull((Object)value, (String)"value")).trim();
        this.internalAdd(name, value);
    }

    public void addDateHeader(String name, Instant time) {
        this.internalAdd(name, time);
    }

    public void setDateHeader(String name, Instant time) {
        this.removeHeader(name);
        this.addDateHeader(name, time);
    }

    public void removeHeader(String name) {
        HeaderKey key = new HeaderKey(name);
        Iterator<Map.Entry<HeaderKey, List<Object>>> it = this.headers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<HeaderKey, List<Object>> header = it.next();
            if (!header.getKey().equals(key)) continue;
            it.remove();
        }
    }

    private String valueToString(Object value) {
        if (value instanceof Instant) {
            return Instants.toRFC7231Format((Instant)((Instant)value));
        }
        return value.toString();
    }

    public boolean containsHeader(String name) {
        HeaderKey searchKey = new HeaderKey(name);
        for (HeaderKey key : this.headers.keySet()) {
            if (!key.equals(searchKey)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getHeaderNames() {
        if (this.headers.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> names = new HashSet<String>(this.headers.size());
        for (HeaderKey key : this.headers.keySet()) {
            names.add(key.getName());
        }
        return names;
    }

    public String[] getHeaderValues(String name) {
        List<Object> objects = this.headers.get(new HeaderKey(name));
        if (objects == null) {
            return NO_VALUES;
        }
        String[] values = new String[objects.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.valueToString(objects.get(i));
        }
        return values;
    }

    public String getHeader(String name) {
        List<Object> objects = this.headers.get(new HeaderKey(name));
        if (objects == null || objects.isEmpty()) {
            return null;
        }
        return this.valueToString(objects.get(0));
    }

    public Instant getDateHeader(String name) {
        List<Object> objects = this.headers.get(new HeaderKey(name));
        if (objects.isEmpty()) {
            return null;
        }
        Object object = objects.get(0);
        if (!(object instanceof Instant)) {
            throw new IllegalStateException("header value is not of type date");
        }
        return (Instant)object;
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public int getCount() {
        return this.headers.size();
    }

    public void clear() {
        this.headers.clear();
    }

    private static class HeaderKey {
        private final String key;
        private final String name;

        private HeaderKey(String name) {
            this.name = Args.notEmpty((String)name, (String)"name").trim();
            this.key = this.name.toLowerCase(Locale.US);
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof HeaderKey)) {
                return false;
            }
            HeaderKey that = (HeaderKey)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

