/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.button;

import de.agilecoders.wicket.core.markup.html.bootstrap.behavior.ICssClassNameProvider;
import de.agilecoders.wicket.core.util.Attributes;
import de.agilecoders.wicket.core.util.Components;
import de.agilecoders.wicket.core.util.CssClassNames;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.util.lang.Args;

public final class Buttons {
    public static void onComponentTag(Component component, ComponentTag tag, ICssClassNameProvider ... classNameProviders) {
        Args.notNull((Object)classNameProviders, (String)"classNameProviders");
        CssClassNames.Builder builder = CssClassNames.newBuilder().add("btn", component.isEnabledInHierarchy() ? "" : "disabled");
        if (!component.isEnabled() && Components.hasTagName(tag, Set.of("a"))) {
            builder.add("disabled");
            Attributes.set(tag, "aria-disabled", "true");
        }
        for (ICssClassNameProvider provider : classNameProviders) {
            builder.add(provider.cssClassName());
        }
        Attributes.addClass(tag, builder.asString());
    }

    private Buttons() {
        throw new UnsupportedOperationException();
    }

    public static enum Type implements ICssClassNameProvider
    {
        Default("btn-secondary"),
        Secondary("btn-secondary"),
        Menu(""),
        Primary("btn-primary"),
        Info("btn-info"),
        Success("btn-success"),
        Warning("btn-warning"),
        Danger("btn-danger"),
        Link("btn-link"),
        Light("btn-light"),
        Dark("btn-dark"),
        Outline_Primary("btn-outline-primary"),
        Outline_Secondary("btn-outline-secondary"),
        Outline_Success("btn-outline-success"),
        Outline_Danger("btn-outline-danger"),
        Outline_Warning("btn-outline-warning"),
        Outline_Info("btn-outline-info"),
        Outline_Light("btn-outline-light"),
        Outline_Dark("btn-outline-dark"),
        NavLink("nav-link");

        private final String cssClassName;

        private Type(String cssClassName) {
            this.cssClassName = cssClassName;
        }

        @Override
        public String cssClassName() {
            return this.cssClassName;
        }
    }

    public static enum Orientation implements ICssClassNameProvider
    {
        Horizontal,
        Vertical;


        @Override
        public String cssClassName() {
            return this.equals(Horizontal) ? "btn-group" : "btn-group-vertical";
        }
    }

    public static enum Size implements ICssClassNameProvider
    {
        Small("btn-sm"),
        Medium(""),
        Large("btn-lg");

        private final String cssClassName;

        private Size(String cssClassName) {
            this.cssClassName = cssClassName;
        }

        @Override
        public String cssClassName() {
            return this.cssClassName;
        }
    }
}

