/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.registry;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Objects;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.toolkit.cli.api.WritableResult;
import org.apache.nifi.toolkit.cli.impl.util.JacksonUtils;

public class VersionedFlowSnapshotsResult
implements WritableResult<Iterator<VersionedFlowSnapshot>> {
    private static final String FILE_NAME_PREFIX = "toolkit_registry_export_all";
    private static final String EXPORT_FILE_NAME = "%s/%s_%s_%s_%d";
    private static final String SEPARATOR = "_";
    private static final String SLASH = "/";
    private static final String REPLACEMENT = "-";
    private final Iterator<VersionedFlowSnapshot> versionedFlowSnapshots;
    private final String exportDirectoryName;

    public VersionedFlowSnapshotsResult(Iterator<VersionedFlowSnapshot> versionedFlowSnapshots, String exportDirectoryName) {
        this.versionedFlowSnapshots = Objects.requireNonNull(versionedFlowSnapshots);
        this.exportDirectoryName = exportDirectoryName;
    }

    @Override
    public Iterator<VersionedFlowSnapshot> getResult() {
        return this.versionedFlowSnapshots;
    }

    @Override
    public void write(PrintStream output) throws IOException {
        while (this.versionedFlowSnapshots.hasNext()) {
            VersionedFlowSnapshot versionedFlowSnapshot = this.versionedFlowSnapshots.next();
            if (this.exportDirectoryName != null) {
                String bucketName = versionedFlowSnapshot.getBucket().getName().replaceAll(SEPARATOR, REPLACEMENT);
                String flowName = versionedFlowSnapshot.getFlow().getName().replaceAll(SEPARATOR, REPLACEMENT).replaceAll(SLASH, REPLACEMENT);
                int version = versionedFlowSnapshot.getSnapshotMetadata().getVersion();
                String exportFileName = String.format(EXPORT_FILE_NAME, this.exportDirectoryName, FILE_NAME_PREFIX, bucketName, flowName, version);
                try {
                    OutputStream resultOut = Files.newOutputStream(Paths.get(exportFileName, new String[0]), new OpenOption[0]);
                    try {
                        JacksonUtils.write(versionedFlowSnapshot, resultOut);
                        continue;
                    }
                    finally {
                        if (resultOut == null) continue;
                        resultOut.close();
                        continue;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to write flow snapshot to: " + exportFileName, e);
                }
            }
            JacksonUtils.write(versionedFlowSnapshot, output);
        }
    }
}

