/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.client;

import java.io.IOException;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.security.util.KeystoreType;
import org.apache.nifi.toolkit.cli.api.ClientFactory;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.client.AccessClient;
import org.apache.nifi.toolkit.client.ConnectionClient;
import org.apache.nifi.toolkit.client.ControllerClient;
import org.apache.nifi.toolkit.client.ControllerServicesClient;
import org.apache.nifi.toolkit.client.CountersClient;
import org.apache.nifi.toolkit.client.FlowClient;
import org.apache.nifi.toolkit.client.InputPortClient;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientConfig;
import org.apache.nifi.toolkit.client.OutputPortClient;
import org.apache.nifi.toolkit.client.ParamContextClient;
import org.apache.nifi.toolkit.client.ParamProviderClient;
import org.apache.nifi.toolkit.client.PoliciesClient;
import org.apache.nifi.toolkit.client.ProcessGroupClient;
import org.apache.nifi.toolkit.client.ProcessorClient;
import org.apache.nifi.toolkit.client.ProvenanceClient;
import org.apache.nifi.toolkit.client.RemoteProcessGroupClient;
import org.apache.nifi.toolkit.client.ReportingTasksClient;
import org.apache.nifi.toolkit.client.RequestConfig;
import org.apache.nifi.toolkit.client.SnippetClient;
import org.apache.nifi.toolkit.client.SystemDiagnosticsClient;
import org.apache.nifi.toolkit.client.TenantsClient;
import org.apache.nifi.toolkit.client.VersionsClient;
import org.apache.nifi.toolkit.client.impl.JerseyNiFiClient;
import org.apache.nifi.toolkit.client.impl.request.BasicAuthRequestConfig;
import org.apache.nifi.toolkit.client.impl.request.BearerTokenRequestConfig;
import org.apache.nifi.toolkit.client.impl.request.OIDCClientCredentialsRequestConfig;
import org.apache.nifi.toolkit.client.impl.request.ProxiedEntityRequestConfig;

public class NiFiClientFactory
implements ClientFactory<NiFiClient> {
    @Override
    public NiFiClient createClient(Properties properties) throws MissingOptionException {
        Integer timeout;
        String url = properties.getProperty(CommandOption.URL.getLongName());
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new MissingOptionException("Missing required option '" + CommandOption.URL.getLongName() + "'");
        }
        String connectionTimeout = properties.getProperty(CommandOption.CONNECTION_TIMEOUT.getLongName());
        String readTimeout = properties.getProperty(CommandOption.READ_TIMEOUT.getLongName());
        String keystore = properties.getProperty(CommandOption.KEYSTORE.getLongName());
        String keystoreType = properties.getProperty(CommandOption.KEYSTORE_TYPE.getLongName());
        String keystorePasswd = properties.getProperty(CommandOption.KEYSTORE_PASSWORD.getLongName());
        String keyPasswd = properties.getProperty(CommandOption.KEY_PASSWORD.getLongName());
        String truststore = properties.getProperty(CommandOption.TRUSTSTORE.getLongName());
        String truststoreType = properties.getProperty(CommandOption.TRUSTSTORE_TYPE.getLongName());
        String truststorePasswd = properties.getProperty(CommandOption.TRUSTSTORE_PASSWORD.getLongName());
        String proxiedEntity = properties.getProperty(CommandOption.PROXIED_ENTITY.getLongName());
        String protocol = properties.getProperty(CommandOption.PROTOCOL.getLongName());
        String basicAuthUsername = properties.getProperty(CommandOption.BASIC_AUTH_USER.getLongName());
        String basicAuthPassword = properties.getProperty(CommandOption.BASIC_AUTH_PASSWORD.getLongName());
        String oidcTokenUrl = properties.getProperty(CommandOption.OIDC_TOKEN_URL.getLongName());
        String oidcClientId = properties.getProperty(CommandOption.OIDC_CLIENT_ID.getLongName());
        String oidcClientSecret = properties.getProperty(CommandOption.OIDC_CLIENT_SECRET.getLongName());
        String bearerToken = properties.getProperty(CommandOption.BEARER_TOKEN.getLongName());
        boolean secureUrl = url.startsWith("https");
        if (secureUrl && (StringUtils.isBlank((CharSequence)truststore) || StringUtils.isBlank((CharSequence)truststoreType) || StringUtils.isBlank((CharSequence)truststorePasswd))) {
            throw new MissingOptionException(CommandOption.TRUSTSTORE.getLongName() + ", " + CommandOption.TRUSTSTORE_TYPE.getLongName() + ", and " + CommandOption.TRUSTSTORE_PASSWORD.getLongName() + " are required when using an https url");
        }
        if (!(StringUtils.isBlank((CharSequence)proxiedEntity) || StringUtils.isBlank((CharSequence)basicAuthUsername) && StringUtils.isBlank((CharSequence)basicAuthPassword))) {
            throw new IllegalStateException(CommandOption.PROXIED_ENTITY.getLongName() + " and basic authentication can not be used together");
        }
        if (!StringUtils.isBlank((CharSequence)proxiedEntity) && !StringUtils.isBlank((CharSequence)bearerToken)) {
            throw new IllegalStateException(CommandOption.PROXIED_ENTITY.getLongName() + " and " + CommandOption.BEARER_TOKEN.getLongName() + " can not be used together");
        }
        if (!(StringUtils.isBlank((CharSequence)bearerToken) || StringUtils.isBlank((CharSequence)basicAuthUsername) && StringUtils.isBlank((CharSequence)basicAuthPassword))) {
            throw new IllegalStateException(CommandOption.BEARER_TOKEN.getLongName() + " and basic authentication can not be used together");
        }
        if (!StringUtils.isBlank((CharSequence)basicAuthUsername) && StringUtils.isBlank((CharSequence)basicAuthPassword)) {
            throw new MissingOptionException(CommandOption.BASIC_AUTH_PASSWORD.getLongName() + " is required when specifying " + CommandOption.BASIC_AUTH_USER.getLongName());
        }
        if (!StringUtils.isBlank((CharSequence)basicAuthPassword) && StringUtils.isBlank((CharSequence)basicAuthUsername)) {
            throw new MissingOptionException(CommandOption.BASIC_AUTH_USER.getLongName() + " is required when specifying " + CommandOption.BASIC_AUTH_PASSWORD.getLongName());
        }
        if (!StringUtils.isBlank((CharSequence)oidcTokenUrl) && StringUtils.isBlank((CharSequence)oidcClientId)) {
            throw new MissingOptionException(CommandOption.OIDC_CLIENT_ID.getLongName() + " is required when specifying " + CommandOption.OIDC_TOKEN_URL.getLongName());
        }
        if (!StringUtils.isBlank((CharSequence)oidcTokenUrl) && StringUtils.isBlank((CharSequence)oidcClientSecret)) {
            throw new MissingOptionException(CommandOption.OIDC_CLIENT_SECRET.getLongName() + " is required when specifying " + CommandOption.OIDC_TOKEN_URL.getLongName());
        }
        NiFiClientConfig.Builder clientConfigBuilder = new NiFiClientConfig.Builder().baseUrl(url);
        if (secureUrl) {
            if (!StringUtils.isBlank((CharSequence)keystore)) {
                clientConfigBuilder.keystoreFilename(keystore);
            }
            if (!StringUtils.isBlank((CharSequence)keystoreType)) {
                clientConfigBuilder.keystoreType(KeystoreType.valueOf((String)keystoreType.toUpperCase()));
            }
            if (!StringUtils.isBlank((CharSequence)keystorePasswd)) {
                clientConfigBuilder.keystorePassword(keystorePasswd);
            }
            if (!StringUtils.isBlank((CharSequence)keyPasswd)) {
                clientConfigBuilder.keyPassword(keyPasswd);
            }
            if (!StringUtils.isBlank((CharSequence)truststore)) {
                clientConfigBuilder.truststoreFilename(truststore);
            }
            if (!StringUtils.isBlank((CharSequence)truststoreType)) {
                clientConfigBuilder.truststoreType(KeystoreType.valueOf((String)truststoreType.toUpperCase()));
            }
            if (!StringUtils.isBlank((CharSequence)truststorePasswd)) {
                clientConfigBuilder.truststorePassword(truststorePasswd);
            }
            if (!StringUtils.isBlank((CharSequence)protocol)) {
                clientConfigBuilder.protocol(protocol);
            }
        }
        if (!StringUtils.isBlank((CharSequence)connectionTimeout)) {
            try {
                timeout = Integer.valueOf(connectionTimeout);
                clientConfigBuilder.connectTimeout(timeout);
            }
            catch (Exception e) {
                throw new MissingOptionException("connectionTimeout has to be an integer");
            }
        }
        if (!StringUtils.isBlank((CharSequence)readTimeout)) {
            try {
                timeout = Integer.valueOf(readTimeout);
                clientConfigBuilder.readTimeout(timeout);
            }
            catch (Exception e) {
                throw new MissingOptionException("readTimeout has to be an integer");
            }
        }
        NiFiClient client = new JerseyNiFiClient.Builder().config(clientConfigBuilder.build()).build();
        if (!StringUtils.isBlank((CharSequence)proxiedEntity)) {
            ProxiedEntityRequestConfig proxiedEntityConfig = new ProxiedEntityRequestConfig(new String[]{proxiedEntity});
            return new NiFiClientWithRequestConfig(client, (RequestConfig)proxiedEntityConfig);
        }
        if (!StringUtils.isBlank((CharSequence)bearerToken)) {
            BearerTokenRequestConfig bearerTokenConfig = new BearerTokenRequestConfig(bearerToken);
            return new NiFiClientWithRequestConfig(client, (RequestConfig)bearerTokenConfig);
        }
        if (!StringUtils.isBlank((CharSequence)basicAuthUsername) && !StringUtils.isBlank((CharSequence)basicAuthPassword)) {
            BasicAuthRequestConfig basicAuthConfig = new BasicAuthRequestConfig(basicAuthUsername, basicAuthPassword);
            return new NiFiClientWithRequestConfig(client, (RequestConfig)basicAuthConfig);
        }
        if (!(StringUtils.isBlank((CharSequence)oidcTokenUrl) || StringUtils.isBlank((CharSequence)oidcClientId) || StringUtils.isBlank((CharSequence)oidcClientSecret))) {
            OIDCClientCredentialsRequestConfig oidcAuthConfig = new OIDCClientCredentialsRequestConfig(clientConfigBuilder.build(), oidcTokenUrl, oidcClientId, oidcClientSecret);
            return new NiFiClientWithRequestConfig(client, (RequestConfig)oidcAuthConfig);
        }
        return client;
    }

    private static class NiFiClientWithRequestConfig
    implements NiFiClient {
        private final NiFiClient wrappedClient;
        private final RequestConfig requestConfig;

        public NiFiClientWithRequestConfig(NiFiClient wrappedClient, RequestConfig requestConfig) {
            this.wrappedClient = wrappedClient;
            this.requestConfig = Objects.requireNonNull(requestConfig);
        }

        public ControllerClient getControllerClient() {
            return this.wrappedClient.getControllerClient(this.requestConfig);
        }

        public ControllerClient getControllerClient(RequestConfig requestConfig) {
            return this.wrappedClient.getControllerClient(requestConfig);
        }

        public ControllerServicesClient getControllerServicesClient() {
            return this.wrappedClient.getControllerServicesClient(this.requestConfig);
        }

        public ControllerServicesClient getControllerServicesClient(RequestConfig requestConfig) {
            return this.wrappedClient.getControllerServicesClient(requestConfig);
        }

        public FlowClient getFlowClient() {
            return this.wrappedClient.getFlowClient(this.requestConfig);
        }

        public FlowClient getFlowClient(RequestConfig requestConfig) {
            return this.wrappedClient.getFlowClient(requestConfig);
        }

        public ProcessGroupClient getProcessGroupClient() {
            return this.wrappedClient.getProcessGroupClient(this.requestConfig);
        }

        public ProcessGroupClient getProcessGroupClient(RequestConfig requestConfig) {
            return this.wrappedClient.getProcessGroupClient(requestConfig);
        }

        public ProcessorClient getProcessorClient() {
            return this.wrappedClient.getProcessorClient(this.requestConfig);
        }

        public ProcessorClient getProcessorClient(RequestConfig requestConfig) {
            return this.wrappedClient.getProcessorClient(requestConfig);
        }

        public VersionsClient getVersionsClient() {
            return this.wrappedClient.getVersionsClient(this.requestConfig);
        }

        public VersionsClient getVersionsClient(RequestConfig requestConfig) {
            return this.wrappedClient.getVersionsClient(requestConfig);
        }

        public TenantsClient getTenantsClient() {
            return this.wrappedClient.getTenantsClient(this.requestConfig);
        }

        public TenantsClient getTenantsClient(RequestConfig requestConfig) {
            return this.wrappedClient.getTenantsClient(requestConfig);
        }

        public PoliciesClient getPoliciesClient() {
            return this.wrappedClient.getPoliciesClient(this.requestConfig);
        }

        public PoliciesClient getPoliciesClient(RequestConfig requestConfig) {
            return this.wrappedClient.getPoliciesClient(requestConfig);
        }

        public ReportingTasksClient getReportingTasksClient() {
            return this.wrappedClient.getReportingTasksClient(this.requestConfig);
        }

        public ReportingTasksClient getReportingTasksClient(RequestConfig requestConfig) {
            return this.wrappedClient.getReportingTasksClient(requestConfig);
        }

        public ParamProviderClient getParamProviderClient() {
            return this.wrappedClient.getParamProviderClient();
        }

        public ParamProviderClient getParamProviderClient(RequestConfig requestConfig) {
            return this.wrappedClient.getParamProviderClient(requestConfig);
        }

        public ParamContextClient getParamContextClient() {
            return this.wrappedClient.getParamContextClient(this.requestConfig);
        }

        public ParamContextClient getParamContextClient(RequestConfig requestConfig) {
            return this.wrappedClient.getParamContextClient(requestConfig);
        }

        public CountersClient getCountersClient() {
            return this.wrappedClient.getCountersClient(this.requestConfig);
        }

        public CountersClient getCountersClient(RequestConfig requestConfig) {
            return this.wrappedClient.getCountersClient(requestConfig);
        }

        public ConnectionClient getConnectionClient() {
            return this.wrappedClient.getConnectionClient(this.requestConfig);
        }

        public ConnectionClient getConnectionClient(RequestConfig requestConfig) {
            return this.wrappedClient.getConnectionClient(requestConfig);
        }

        public RemoteProcessGroupClient getRemoteProcessGroupClient() {
            return this.wrappedClient.getRemoteProcessGroupClient(this.requestConfig);
        }

        public RemoteProcessGroupClient getRemoteProcessGroupClient(RequestConfig requestConfig) {
            return this.wrappedClient.getRemoteProcessGroupClient(requestConfig);
        }

        public InputPortClient getInputPortClient() {
            return this.wrappedClient.getInputPortClient(this.requestConfig);
        }

        public InputPortClient getInputPortClient(RequestConfig requestConfig) {
            return this.wrappedClient.getInputPortClient(requestConfig);
        }

        public OutputPortClient getOutputPortClient() {
            return this.wrappedClient.getOutputPortClient(this.requestConfig);
        }

        public OutputPortClient getOutputPortClient(RequestConfig requestConfig) {
            return this.wrappedClient.getOutputPortClient(requestConfig);
        }

        public ProvenanceClient getProvenanceClient() {
            return this.wrappedClient.getProvenanceClient(this.requestConfig);
        }

        public ProvenanceClient getProvenanceClient(RequestConfig requestConfig) {
            return this.wrappedClient.getProvenanceClient(requestConfig);
        }

        public AccessClient getAccessClient() {
            return this.wrappedClient.getAccessClient();
        }

        public SnippetClient getSnippetClient() {
            return this.wrappedClient.getSnippetClient();
        }

        public SnippetClient getSnippetClient(RequestConfig requestConfig) {
            return this.wrappedClient.getSnippetClient(requestConfig);
        }

        public SystemDiagnosticsClient getSystemsDiagnosticsClient() {
            return this.wrappedClient.getSystemsDiagnosticsClient();
        }

        public SystemDiagnosticsClient getSystemsDiagnosticsClient(RequestConfig requestConfig) {
            return this.wrappedClient.getSystemsDiagnosticsClient(requestConfig);
        }

        public void close() throws IOException {
            this.wrappedClient.close();
        }
    }
}

