/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.attribute.expression.language.evaluation.functions;

import org.apache.nifi.attribute.expression.language.EvaluationContext;
import org.apache.nifi.attribute.expression.language.evaluation.BooleanEvaluator;
import org.apache.nifi.attribute.expression.language.evaluation.BooleanQueryResult;
import org.apache.nifi.attribute.expression.language.evaluation.Evaluator;
import org.apache.nifi.attribute.expression.language.evaluation.QueryResult;

public class GreaterThanOrEqualEvaluator
extends BooleanEvaluator {
    private final Evaluator<Number> subject;
    private final Evaluator<Number> comparison;

    public GreaterThanOrEqualEvaluator(Evaluator<Number> subject, Evaluator<Number> comparison) {
        this.subject = subject;
        this.comparison = comparison;
    }

    @Override
    public QueryResult<Boolean> evaluate(EvaluationContext evaluationContext) {
        Number subjectValue = this.subject.evaluate(evaluationContext).getValue();
        if (subjectValue == null) {
            return new BooleanQueryResult(false);
        }
        Number comparisonValue = this.comparison.evaluate(evaluationContext).getValue();
        if (comparisonValue == null) {
            return new BooleanQueryResult(false);
        }
        if (subjectValue instanceof Double || comparisonValue instanceof Double) {
            return new BooleanQueryResult(subjectValue.doubleValue() >= comparisonValue.doubleValue());
        }
        return new BooleanQueryResult(subjectValue.longValue() >= comparisonValue.longValue());
    }

    @Override
    public Evaluator<?> getSubjectEvaluator() {
        return this.subject;
    }
}

