/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.result.registry;

import java.io.PrintStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.api.ReferenceResolver;
import org.apache.nifi.toolkit.cli.api.Referenceable;
import org.apache.nifi.toolkit.cli.api.ResolvedReference;
import org.apache.nifi.toolkit.cli.api.ResultType;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.result.AbstractWritableResult;
import org.apache.nifi.toolkit.cli.impl.result.writer.DynamicTableWriter;
import org.apache.nifi.toolkit.cli.impl.result.writer.Table;

public class BucketsResult
extends AbstractWritableResult<List<Bucket>>
implements Referenceable {
    private final List<Bucket> buckets;

    public BucketsResult(ResultType resultType, List<Bucket> buckets) {
        super(resultType);
        this.buckets = Objects.requireNonNull(buckets);
        this.buckets.sort(Comparator.comparing(Bucket::getName));
    }

    @Override
    public List<Bucket> getResult() {
        return this.buckets;
    }

    @Override
    protected void writeSimpleResult(PrintStream output) {
        if (this.buckets.isEmpty()) {
            return;
        }
        Table table = new Table.Builder().column("#", 3, 3, false).column("Name", 20, 36, true).column("Id", 36, 36, false).column("Description", 11, 40, true).build();
        for (int i = 0; i < this.buckets.size(); ++i) {
            Bucket bucket = this.buckets.get(i);
            table.addRow(String.valueOf(i + 1), bucket.getName(), bucket.getIdentifier(), bucket.getDescription());
        }
        DynamicTableWriter tableWriter = new DynamicTableWriter();
        tableWriter.write(table, output);
    }

    @Override
    public ReferenceResolver createReferenceResolver(Context context) {
        final HashMap backRefs = new HashMap();
        AtomicInteger position = new AtomicInteger(0);
        this.buckets.forEach(b -> backRefs.put(position.incrementAndGet(), b));
        return new ReferenceResolver(){

            @Override
            public ResolvedReference resolve(CommandOption option, Integer position) {
                Bucket bucket = (Bucket)backRefs.get(position);
                if (bucket != null) {
                    return new ResolvedReference(option, position, bucket.getName(), bucket.getIdentifier());
                }
                return null;
            }

            @Override
            public boolean isEmpty() {
                return backRefs.isEmpty();
            }
        };
    }
}

