/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.nifi.params;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.MissingOptionException;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.nifi.AbstractNiFiCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;
import org.apache.nifi.toolkit.client.ControllerClient;
import org.apache.nifi.toolkit.client.NiFiClient;
import org.apache.nifi.toolkit.client.NiFiClientException;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ParameterProviderDTO;
import org.apache.nifi.web.api.entity.ParameterProviderEntity;

public class CreateParamProvider
extends AbstractNiFiCommand<StringResult> {
    public CreateParamProvider() {
        super("create-param-provider", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Creates a parameter provider. After creating the parameter provider, its properties can be configured using the set-param-provider-property command.";
    }

    @Override
    protected void doInitialize(Context context) {
        super.doInitialize(context);
        this.addOption(CommandOption.PARAM_PROVIDER_NAME.createOption());
        this.addOption(CommandOption.PARAM_PROVIDER_TYPE.createOption());
        this.addOption(CommandOption.PARAM_PROVIDER_GROUP_ID.createOption());
        this.addOption(CommandOption.PARAM_PROVIDER_ARTIFACT_ID.createOption());
        this.addOption(CommandOption.PARAM_PROVIDER_VERSION.createOption());
    }

    @Override
    public StringResult doExecute(NiFiClient client, Properties properties) throws NiFiClientException, IOException, MissingOptionException, CommandException {
        String paramProviderName = this.getRequiredArg(properties, CommandOption.PARAM_PROVIDER_NAME);
        String paramProviderType = this.getRequiredArg(properties, CommandOption.PARAM_PROVIDER_TYPE);
        String bundleGroupId = this.getRequiredArg(properties, CommandOption.PARAM_PROVIDER_GROUP_ID);
        String bundleArtifactId = this.getRequiredArg(properties, CommandOption.PARAM_PROVIDER_ARTIFACT_ID);
        String bundleVersion = this.getRequiredArg(properties, CommandOption.PARAM_PROVIDER_VERSION);
        ParameterProviderDTO paramProviderDTO = new ParameterProviderDTO();
        paramProviderDTO.setName(paramProviderName);
        paramProviderDTO.setType(paramProviderType);
        BundleDTO bundle = new BundleDTO();
        bundle.setArtifact(bundleArtifactId);
        bundle.setGroup(bundleGroupId);
        bundle.setVersion(bundleVersion);
        paramProviderDTO.setBundle(bundle);
        ParameterProviderEntity paramProviderEntity = new ParameterProviderEntity();
        paramProviderEntity.setComponent(paramProviderDTO);
        paramProviderEntity.setRevision(this.getInitialRevisionDTO());
        ControllerClient controllerClient = client.getControllerClient();
        ParameterProviderEntity createdParamProvider = controllerClient.createParamProvider(paramProviderEntity);
        return new StringResult(createdParamProvider.getId(), this.isInteractive());
    }
}

