/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.scanner.filesystem;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.internal.resource.filesystem.FileSystemResource;
import org.flywaydb.core.internal.scanner.filesystem.DirectoryValidationResult;
import org.flywaydb.core.internal.sqlscript.SqlScriptMetadata;

public class FileSystemScanner {
    @Generated
    private static final Log LOG = LogFactory.getLog(FileSystemScanner.class);
    private final Charset defaultEncoding;
    private final boolean detectEncoding;
    private final boolean throwOnMissingLocations;
    private final boolean stream;
    private Configuration config;

    public FileSystemScanner(boolean stream, Configuration config) {
        this.defaultEncoding = config.getEncoding();
        this.detectEncoding = config.isDetectEncoding();
        this.stream = stream;
        this.throwOnMissingLocations = config.isFailOnMissingLocations();
        this.config = config;
    }

    public Collection<LoadableResource> scanForResources(Location location) {
        String path = location.getRootPath();
        LOG.debug("Scanning for filesystem resources at '" + path + "'");
        File dir = new File(path);
        DirectoryValidationResult validationResult = this.getDirectoryValidationResult(dir);
        if (validationResult != DirectoryValidationResult.VALID) {
            if (this.throwOnMissingLocations) {
                throw new FlywayException("Failed to find filesystem location: " + path + " (" + String.valueOf((Object)validationResult) + ")");
            }
            LOG.error("Skipping filesystem location: " + path + " (" + String.valueOf((Object)validationResult) + ")");
            return Collections.emptyList();
        }
        TreeSet<LoadableResource> resources = new TreeSet<LoadableResource>();
        for (String resourceName : this.findResourceNamesFromFileSystem(path, dir)) {
            FileSystemResource metadataResource;
            SqlScriptMetadata metadata;
            boolean detectEncodingForThisResource = this.detectEncoding;
            if (!location.matchesPath(resourceName)) continue;
            Charset encoding = this.defaultEncoding;
            Object encodingBlurb = "";
            if (new File(resourceName + ".conf").exists() && (metadata = SqlScriptMetadata.fromResource(metadataResource = new FileSystemResource(location, resourceName + ".conf", this.defaultEncoding, false), null, this.config)).encoding() != null) {
                encoding = Charset.forName(metadata.encoding());
                detectEncodingForThisResource = false;
                encodingBlurb = " (with overriding encoding " + String.valueOf(encoding) + ")";
            }
            resources.add(new FileSystemResource(location, resourceName, encoding, detectEncodingForThisResource, this.stream));
            LOG.debug("Found filesystem resource: " + resourceName + (String)encodingBlurb);
        }
        return resources;
    }

    private DirectoryValidationResult getDirectoryValidationResult(File directory) {
        if (!directory.exists()) {
            return DirectoryValidationResult.NOT_FOUND;
        }
        if (!directory.canRead()) {
            return DirectoryValidationResult.NOT_READABLE;
        }
        if (!directory.isDirectory()) {
            return DirectoryValidationResult.NOT_A_DIRECTORY;
        }
        return DirectoryValidationResult.VALID;
    }

    private Set<String> findResourceNamesFromFileSystem(String scanRootLocation, File folder) {
        String path = folder.getPath();
        LOG.debug("Scanning for resources in path: " + folder.getPath() + " (" + scanRootLocation + ")");
        TreeSet<String> resourceNames = new TreeSet<String>();
        File[] files = folder.listFiles();
        if (files == null) {
            if (this.throwOnMissingLocations) {
                throw new FlywayException("Failed to find filesystem location: " + path + " (" + String.valueOf((Object)DirectoryValidationResult.UNABLE_TO_ACCESS_FOLDER) + ")");
            }
            LOG.error("Skipping filesystem location: " + path + " (" + String.valueOf((Object)DirectoryValidationResult.UNABLE_TO_ACCESS_FOLDER) + ")");
            return Collections.emptySet();
        }
        for (File file : files) {
            if (!file.canRead()) continue;
            if (file.isDirectory()) {
                if (file.isHidden()) {
                    LOG.debug("Skipping hidden directory: " + file.getAbsolutePath());
                    continue;
                }
                resourceNames.addAll(this.findResourceNamesFromFileSystem(scanRootLocation, file));
                continue;
            }
            resourceNames.add(file.getPath());
        }
        return resourceNames;
    }
}

