/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.security.authorization.database;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import org.apache.commons.lang3.Validate;
import org.apache.nifi.registry.security.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.registry.security.authorization.ConfigurableUserGroupProvider;
import org.apache.nifi.registry.security.authorization.Group;
import org.apache.nifi.registry.security.authorization.User;
import org.apache.nifi.registry.security.authorization.UserAndGroups;
import org.apache.nifi.registry.security.authorization.UserGroupProviderInitializationContext;
import org.apache.nifi.registry.security.authorization.annotation.AuthorizerContext;
import org.apache.nifi.registry.security.authorization.database.DatabaseUserGroupHolder;
import org.apache.nifi.registry.security.authorization.database.entity.DatabaseGroup;
import org.apache.nifi.registry.security.authorization.database.entity.DatabaseUser;
import org.apache.nifi.registry.security.authorization.database.mapper.DatabaseGroupRowMapper;
import org.apache.nifi.registry.security.authorization.database.mapper.DatabaseUserRowMapper;
import org.apache.nifi.registry.security.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.registry.security.authorization.exception.UninheritableAuthorizationsException;
import org.apache.nifi.registry.security.authorization.util.UserGroupProviderUtils;
import org.apache.nifi.registry.security.exception.SecurityProviderCreationException;
import org.apache.nifi.registry.security.exception.SecurityProviderDestructionException;
import org.apache.nifi.registry.security.identity.IdentityMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class DatabaseUserGroupProvider
implements ConfigurableUserGroupProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseUserGroupProvider.class);
    private DataSource dataSource;
    private IdentityMapper identityMapper;
    private JdbcTemplate jdbcTemplate;
    private final AtomicReference<DatabaseUserGroupHolder> userGroupHolder = new AtomicReference();

    @AuthorizerContext
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @AuthorizerContext
    public void setIdentityMapper(IdentityMapper identityMapper) {
        this.identityMapper = identityMapper;
    }

    public void initialize(UserGroupProviderInitializationContext initializationContext) throws SecurityProviderCreationException {
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
    }

    public void onConfigured(AuthorizerConfigurationContext configurationContext) throws SecurityProviderCreationException {
        this.refreshUserGroupHolder();
        Set<String> initialUserIdentities = UserGroupProviderUtils.getInitialUserIdentities(configurationContext, this.identityMapper);
        for (String initialUserIdentity : initialUserIdentities) {
            User existingUser = this.getUserByIdentity(initialUserIdentity);
            if (existingUser == null) {
                User initialUser = new User.Builder().identifierGenerateFromSeed(initialUserIdentity).identity(initialUserIdentity).build();
                this.addUser(initialUser);
                LOGGER.info("Created initial user with identity {}", (Object)initialUserIdentity);
                continue;
            }
            LOGGER.debug("User already exists with identity {}", (Object)initialUserIdentity);
        }
    }

    public void preDestruction() throws SecurityProviderDestructionException {
    }

    public String getFingerprint() throws AuthorizationAccessException {
        throw new UnsupportedOperationException("Fingerprinting is not supported by this provider");
    }

    public void inheritFingerprint(String fingerprint) throws AuthorizationAccessException {
        throw new UnsupportedOperationException("Fingerprinting is not supported by this provider");
    }

    public void checkInheritability(String proposedFingerprint) throws AuthorizationAccessException, UninheritableAuthorizationsException {
        throw new UnsupportedOperationException("Fingerprinting is not supported by this provider");
    }

    public synchronized User addUser(User user) throws AuthorizationAccessException {
        Objects.requireNonNull(user);
        String sql = "INSERT INTO UGP_USER(IDENTIFIER, IDENTITY) VALUES (?, ?)";
        this.jdbcTemplate.update("INSERT INTO UGP_USER(IDENTIFIER, IDENTITY) VALUES (?, ?)", new Object[]{user.getIdentifier(), user.getIdentity()});
        this.refreshUserGroupHolder();
        return user;
    }

    public synchronized User updateUser(User user) throws AuthorizationAccessException {
        Objects.requireNonNull(user);
        String sql = "UPDATE UGP_USER SET IDENTITY = ? WHERE IDENTIFIER = ?";
        int updated = this.jdbcTemplate.update("UPDATE UGP_USER SET IDENTITY = ? WHERE IDENTIFIER = ?", new Object[]{user.getIdentity(), user.getIdentifier()});
        if (updated <= 0) {
            return null;
        }
        this.refreshUserGroupHolder();
        return user;
    }

    public Set<User> getUsers() throws AuthorizationAccessException {
        return this.userGroupHolder.get().getAllUsers();
    }

    private Set<User> getDatabaseUsers() throws AuthorizationAccessException {
        String sql = "SELECT * FROM UGP_USER";
        List databaseUsers = this.jdbcTemplate.query("SELECT * FROM UGP_USER", (RowMapper)new DatabaseUserRowMapper());
        HashSet<User> users = new HashSet<User>();
        databaseUsers.forEach(u -> users.add(this.mapToUser((DatabaseUser)u)));
        return users;
    }

    public User getUser(String identifier) throws AuthorizationAccessException {
        Validate.notBlank((CharSequence)identifier);
        return this.userGroupHolder.get().getUsersById().get(identifier);
    }

    public User getUserByIdentity(String identity) throws AuthorizationAccessException {
        Validate.notBlank((CharSequence)identity);
        return this.userGroupHolder.get().getUsersByIdentity().get(identity);
    }

    public UserAndGroups getUserAndGroups(String userIdentity) throws AuthorizationAccessException {
        Validate.notBlank((CharSequence)userIdentity);
        final User user = this.userGroupHolder.get().getUser(userIdentity);
        final Set<Group> groups = this.userGroupHolder.get().getGroups(userIdentity);
        return new UserAndGroups(){

            public User getUser() {
                return user;
            }

            public Set<Group> getGroups() {
                return groups;
            }
        };
    }

    public synchronized User deleteUser(User user) throws AuthorizationAccessException {
        Objects.requireNonNull(user);
        String deleteFromUserGroupSql = "DELETE FROM UGP_USER_GROUP WHERE USER_IDENTIFIER = ?";
        this.jdbcTemplate.update("DELETE FROM UGP_USER_GROUP WHERE USER_IDENTIFIER = ?", new Object[]{user.getIdentifier()});
        String deleteFromUserSql = "DELETE FROM UGP_USER WHERE IDENTIFIER = ?";
        int rowsDeletedFromUser = this.jdbcTemplate.update("DELETE FROM UGP_USER WHERE IDENTIFIER = ?", new Object[]{user.getIdentifier()});
        if (rowsDeletedFromUser <= 0) {
            return null;
        }
        this.refreshUserGroupHolder();
        return user;
    }

    private User mapToUser(DatabaseUser databaseUser) {
        return new User.Builder().identifier(databaseUser.getIdentifier()).identity(databaseUser.getIdentity()).build();
    }

    public synchronized Group addGroup(Group group) throws AuthorizationAccessException {
        Objects.requireNonNull(group);
        String groupSql = "INSERT INTO UGP_GROUP(IDENTIFIER, IDENTITY) VALUES (?, ?)";
        this.jdbcTemplate.update("INSERT INTO UGP_GROUP(IDENTIFIER, IDENTITY) VALUES (?, ?)", new Object[]{group.getIdentifier(), group.getName()});
        this.createUserGroups(group);
        this.refreshUserGroupHolder();
        return group;
    }

    public synchronized Group updateGroup(Group group) throws AuthorizationAccessException {
        Objects.requireNonNull(group);
        String updateGroupSql = "UPDATE UGP_GROUP SET IDENTITY = ? WHERE IDENTIFIER = ?";
        int updated = this.jdbcTemplate.update("UPDATE UGP_GROUP SET IDENTITY = ? WHERE IDENTIFIER = ?", new Object[]{group.getName(), group.getIdentifier()});
        if (updated <= 0) {
            return null;
        }
        String deleteUserGroups = "DELETE FROM UGP_USER_GROUP WHERE GROUP_IDENTIFIER = ?";
        this.jdbcTemplate.update("DELETE FROM UGP_USER_GROUP WHERE GROUP_IDENTIFIER = ?", new Object[]{group.getIdentifier()});
        this.createUserGroups(group);
        this.refreshUserGroupHolder();
        return group;
    }

    public Set<Group> getGroups() throws AuthorizationAccessException {
        return this.userGroupHolder.get().getAllGroups();
    }

    private Set<Group> getDatabaseGroups() throws AuthorizationAccessException {
        String sql = "SELECT * FROM UGP_GROUP";
        List databaseGroups = this.jdbcTemplate.query("SELECT * FROM UGP_GROUP", (RowMapper)new DatabaseGroupRowMapper());
        HashMap groupToUsers = new HashMap();
        this.jdbcTemplate.query("SELECT * FROM UGP_USER_GROUP", rs -> {
            String groupIdentifier = rs.getString("GROUP_IDENTIFIER");
            String userIdentifier = rs.getString("USER_IDENTIFIER");
            Set userIdentifiers = groupToUsers.computeIfAbsent(groupIdentifier, k -> new HashSet());
            userIdentifiers.add(userIdentifier);
        });
        HashSet<Group> groups = new HashSet<Group>();
        databaseGroups.forEach(g -> groups.add(this.mapToGroup((DatabaseGroup)g, (Set)groupToUsers.get(g.getIdentifier()))));
        return groups;
    }

    public Group getGroup(String groupIdentifier) throws AuthorizationAccessException {
        Validate.notBlank((CharSequence)groupIdentifier);
        return this.userGroupHolder.get().getGroupsById().get(groupIdentifier);
    }

    public synchronized Group deleteGroup(Group group) throws AuthorizationAccessException {
        Objects.requireNonNull(group);
        String sql = "DELETE FROM UGP_GROUP WHERE IDENTIFIER = ?";
        int rowsUpdated = this.jdbcTemplate.update("DELETE FROM UGP_GROUP WHERE IDENTIFIER = ?", new Object[]{group.getIdentifier()});
        if (rowsUpdated <= 0) {
            return null;
        }
        this.refreshUserGroupHolder();
        return group;
    }

    private void createUserGroups(Group group) {
        if (group.getUsers() != null) {
            for (String userIdentifier : group.getUsers()) {
                String userGroupSql = "INSERT INTO UGP_USER_GROUP (USER_IDENTIFIER, GROUP_IDENTIFIER) VALUES (?, ?)";
                this.jdbcTemplate.update("INSERT INTO UGP_USER_GROUP (USER_IDENTIFIER, GROUP_IDENTIFIER) VALUES (?, ?)", new Object[]{userIdentifier, group.getIdentifier()});
            }
        }
    }

    private Group mapToGroup(DatabaseGroup databaseGroup, Set<String> userIdentifiers) {
        return new Group.Builder().identifier(databaseGroup.getIdentifier()).name(databaseGroup.getIdentity()).addUsers(userIdentifiers == null ? Collections.emptySet() : userIdentifiers).build();
    }

    private synchronized void refreshUserGroupHolder() {
        Set<User> allUsers = this.getDatabaseUsers();
        Set<Group> allGroups = this.getDatabaseGroups();
        this.userGroupHolder.set(new DatabaseUserGroupHolder(allUsers, allGroups));
    }

    private <T> T queryForObject(String sql, RowMapper<T> rowMapper, Object ... args) {
        try {
            return (T)this.jdbcTemplate.queryForObject(sql, rowMapper, args);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }
}

