/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.javascript2.editor.formatter.ui;

import java.io.IOException;
import org.netbeans.modules.javascript2.editor.formatter.FmtOptions;
import static org.netbeans.modules.javascript2.editor.formatter.FmtOptions.CategorySupport.OPTION_ID;
import static org.netbeans.modules.javascript2.editor.formatter.FmtOptions.maxPreservedArrayLines;
import static org.netbeans.modules.javascript2.editor.formatter.FmtOptions.maxPreservedClassLines;
import org.netbeans.modules.javascript2.editor.formatter.Utils;
import org.netbeans.modules.javascript2.lexer.api.JsTokenId;
import org.netbeans.modules.options.editor.spi.PreferencesCustomizer;
import static org.netbeans.modules.javascript2.editor.formatter.FmtOptions.maxPreservedObjectLines;
import org.netbeans.modules.javascript2.editor.ui.NumericKeyListener;

/**
 *
 * @author Petr Hejl
 */
public class FmtBlankLines extends javax.swing.JPanel {

    /**
     * Creates new form FmtBlankLines
     */
    public FmtBlankLines() {
        initComponents();
        
        scrollPane.getViewport().setBackground(java.awt.SystemColor.controlLtHighlight);
        
        maxClassTextField.putClientProperty(OPTION_ID, maxPreservedClassLines);
        maxObjectTextField.putClientProperty(OPTION_ID, maxPreservedObjectLines);
        maxArrayTextField.putClientProperty(OPTION_ID, maxPreservedArrayLines);
        //maxCodeTextField.putClientProperty(OPTION_ID, maxPreservedCodeLines);
        
        NumericKeyListener listener = new NumericKeyListener();
        maxClassTextField.addKeyListener(listener);
        maxObjectTextField.addKeyListener(listener);
        maxArrayTextField.addKeyListener(listener);
    }
    
    public static PreferencesCustomizer.Factory getController() {
        String preview = "";
        try {
            preview = Utils.loadPreviewText(FmtBlankLines.class.getClassLoader().getResourceAsStream("org/netbeans/modules/javascript2/editor/formatter/ui/BlankLines.js"));
        } catch (IOException ex) {
            // TODO log it
        }
        return new FmtOptions.CategorySupport.Factory(JsTokenId.JAVASCRIPT_MIME_TYPE, "blank-lines", FmtBlankLines.class, //NOI18N
                preview);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        scrollPane = new javax.swing.JScrollPane();
        panel1 = new javax.swing.JPanel();
        maximumLabel = new javax.swing.JLabel();
        jSeparator1 = new javax.swing.JSeparator();
        maxObjectLabel = new javax.swing.JLabel();
        maxObjectTextField = new javax.swing.JTextField();
        maxClassLabel = new javax.swing.JLabel();
        maxClassTextField = new javax.swing.JTextField();
        maxArrayLabel = new javax.swing.JLabel();
        maxArrayTextField = new javax.swing.JTextField();

        setName(org.openide.util.NbBundle.getMessage(FmtBlankLines.class, "LBL_BlankLines")); // NOI18N
        setLayout(new java.awt.BorderLayout());

        scrollPane.setMinimumSize(new java.awt.Dimension(300, 200));

        org.openide.awt.Mnemonics.setLocalizedText(maximumLabel, org.openide.util.NbBundle.getMessage(FmtBlankLines.class, "FmtBlankLines.maximumLabel.text")); // NOI18N

        maxObjectLabel.setLabelFor(maxObjectTextField);
        org.openide.awt.Mnemonics.setLocalizedText(maxObjectLabel, org.openide.util.NbBundle.getMessage(FmtBlankLines.class, "FmtBlankLines.maxObjectLabel.text")); // NOI18N

        maxObjectTextField.setColumns(3);

        maxClassLabel.setLabelFor(maxClassTextField);
        org.openide.awt.Mnemonics.setLocalizedText(maxClassLabel, org.openide.util.NbBundle.getMessage(FmtBlankLines.class, "FmtBlankLines.maxClassLabel.text")); // NOI18N

        maxClassTextField.setColumns(3);

        maxArrayLabel.setLabelFor(maxArrayTextField);
        org.openide.awt.Mnemonics.setLocalizedText(maxArrayLabel, org.openide.util.NbBundle.getMessage(FmtBlankLines.class, "FmtBlankLines.maxArrayLabel.text")); // NOI18N

        maxArrayTextField.setColumns(3);

        javax.swing.GroupLayout panel1Layout = new javax.swing.GroupLayout(panel1);
        panel1.setLayout(panel1Layout);
        panel1Layout.setHorizontalGroup(
            panel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(panel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(panel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(panel1Layout.createSequentialGroup()
                        .addComponent(maximumLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jSeparator1, javax.swing.GroupLayout.DEFAULT_SIZE, 71, Short.MAX_VALUE))
                    .addGroup(panel1Layout.createSequentialGroup()
                        .addGap(12, 12, 12)
                        .addGroup(panel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(maxObjectLabel)
                            .addComponent(maxClassLabel)
                            .addComponent(maxArrayLabel))
                        .addGap(0, 0, Short.MAX_VALUE)
                        .addGroup(panel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(panel1Layout.createSequentialGroup()
                                .addGap(16, 16, 16)
                                .addComponent(maxClassTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addComponent(maxObjectTextField, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(maxArrayTextField, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap())
        );
        panel1Layout.setVerticalGroup(
            panel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(panel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(panel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(maximumLabel)
                    .addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(panel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(maxClassLabel)
                    .addComponent(maxClassTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(panel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(maxObjectLabel)
                    .addComponent(maxObjectTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(panel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(maxArrayLabel)
                    .addComponent(maxArrayTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(95, Short.MAX_VALUE))
        );

        scrollPane.setViewportView(panel1);

        add(scrollPane, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JLabel maxArrayLabel;
    private javax.swing.JTextField maxArrayTextField;
    private javax.swing.JLabel maxClassLabel;
    private javax.swing.JTextField maxClassTextField;
    private javax.swing.JLabel maxObjectLabel;
    private javax.swing.JTextField maxObjectTextField;
    private javax.swing.JLabel maximumLabel;
    private javax.swing.JPanel panel1;
    private javax.swing.JScrollPane scrollPane;
    // End of variables declaration//GEN-END:variables
}
