/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.overridden;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.MethodTree;
import jpt.sun.source.tree.Tree;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.ExecutableElement;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;

class IsOverriddenVisitor
extends CancellableTreePathScanner<Void, Tree> {
    private static final Logger LOG = Logger.getLogger(IsOverriddenVisitor.class.getName());
    private final CompilationInfo info;
    Map<ElementHandle<TypeElement>, List<ElementHandle<ExecutableElement>>> type2Declaration;
    Map<ElementHandle<ExecutableElement>, MethodTree> declaration2Tree;
    Map<ElementHandle<TypeElement>, ClassTree> declaration2Class;
    private final Map<TypeElement, ElementHandle<TypeElement>> type2Handle;
    private ElementHandle<TypeElement> currentClass;

    IsOverriddenVisitor(CompilationInfo info, AtomicBoolean cancel) {
        super(cancel);
        this.info = info;
        this.type2Declaration = new HashMap<ElementHandle<TypeElement>, List<ElementHandle<ExecutableElement>>>();
        this.declaration2Tree = new HashMap<ElementHandle<ExecutableElement>, MethodTree>();
        this.declaration2Class = new HashMap<ElementHandle<TypeElement>, ClassTree>();
        this.type2Handle = new HashMap<TypeElement, ElementHandle<TypeElement>>();
    }

    private ElementHandle<TypeElement> getHandle(TypeElement type) {
        return this.type2Handle.computeIfAbsent(type, k -> ElementHandle.create(type));
    }

    @Override
    public Void visitMethod(MethodTree tree, Tree d) {
        Element el;
        if (this.currentClass != null && (el = this.info.getTrees().getElement(this.getCurrentPath())) != null && el.getKind() == ElementKind.METHOD && !el.getModifiers().contains((Object)Modifier.PRIVATE) && !el.getModifiers().contains((Object)Modifier.STATIC)) {
            ExecutableElement overridee = (ExecutableElement)el;
            List methods = this.type2Declaration.computeIfAbsent(this.currentClass, k -> new ArrayList());
            try {
                ElementHandle<ExecutableElement> methodHandle = ElementHandle.create(overridee);
                methods.add(methodHandle);
                this.declaration2Tree.put(methodHandle, tree);
            }
            catch (IllegalArgumentException iae) {
                LOG.log(Level.INFO, "Unresolvable method: {0}, reason: {1}", new Object[]{overridee, iae.getMessage()});
            }
        }
        super.visitMethod(tree, tree);
        return null;
    }

    @Override
    public Void visitClass(ClassTree tree, Tree d) {
        Element decl = this.info.getTrees().getElement(this.getCurrentPath());
        if (decl != null && (decl.getKind().isClass() || decl.getKind().isInterface())) {
            ElementHandle<TypeElement> oldCurrentClass = this.currentClass;
            this.currentClass = this.getHandle((TypeElement)decl);
            this.declaration2Class.put(this.currentClass, tree);
            super.visitClass(tree, d);
            this.currentClass = oldCurrentClass;
        } else {
            super.visitClass(tree, d);
        }
        return null;
    }
}

