/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.code;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import jpt.sun.tools.javac.code.Symbol;
import jpt.sun.tools.javac.util.List;
import jpt30.lang.model.element.ModuleElement;

public abstract class Directive
implements ModuleElement.Directive {

    public static class UsesDirective
    extends Directive
    implements ModuleElement.UsesDirective {
        public final Symbol.ClassSymbol service;

        public UsesDirective(Symbol.ClassSymbol service) {
            this.service = service;
        }

        @Override
        public ModuleElement.DirectiveKind getKind() {
            return ModuleElement.DirectiveKind.USES;
        }

        @Override
        public Symbol.ClassSymbol getService() {
            return this.service;
        }

        public String toString() {
            return "Uses[" + this.service + "]";
        }

        @Override
        public <R, P> R accept(ModuleElement.DirectiveVisitor<R, P> v, P p) {
            return v.visitUses(this, p);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof UsesDirective)) return false;
            UsesDirective directive = (UsesDirective)obj;
            if (this.service != directive.service) return false;
            return true;
        }

        public int hashCode() {
            return this.service.hashCode() * 31;
        }
    }

    public static class RequiresDirective
    extends Directive
    implements ModuleElement.RequiresDirective {
        public final Symbol.ModuleSymbol module;
        public final Set<RequiresFlag> flags;

        public RequiresDirective(Symbol.ModuleSymbol module) {
            this(module, EnumSet.noneOf(RequiresFlag.class));
        }

        public RequiresDirective(Symbol.ModuleSymbol module, Set<RequiresFlag> flags) {
            this.module = module;
            this.flags = flags;
        }

        @Override
        public ModuleElement.DirectiveKind getKind() {
            return ModuleElement.DirectiveKind.REQUIRES;
        }

        @Override
        public boolean isStatic() {
            return this.flags.contains((Object)RequiresFlag.STATIC_PHASE);
        }

        @Override
        public boolean isTransitive() {
            return this.flags.contains((Object)RequiresFlag.TRANSITIVE);
        }

        @Override
        public Symbol.ModuleSymbol getDependency() {
            return this.module;
        }

        public String toString() {
            return "Requires[" + this.flags + "," + this.module + "]";
        }

        @Override
        public <R, P> R accept(ModuleElement.DirectiveVisitor<R, P> v, P p) {
            return v.visitRequires(this, p);
        }
    }

    public static class ProvidesDirective
    extends Directive
    implements ModuleElement.ProvidesDirective {
        public final Symbol.ClassSymbol service;
        public final List<Symbol.ClassSymbol> impls;

        public ProvidesDirective(Symbol.ClassSymbol service, List<Symbol.ClassSymbol> impls) {
            this.service = service;
            this.impls = impls;
        }

        @Override
        public ModuleElement.DirectiveKind getKind() {
            return ModuleElement.DirectiveKind.PROVIDES;
        }

        @Override
        public Symbol.ClassSymbol getService() {
            return this.service;
        }

        public List<Symbol.ClassSymbol> getImplementations() {
            return this.impls;
        }

        public String toString() {
            return "Provides[" + this.service + "," + this.impls + "]";
        }

        @Override
        public <R, P> R accept(ModuleElement.DirectiveVisitor<R, P> v, P p) {
            return v.visitProvides(this, p);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof ProvidesDirective)) return false;
            ProvidesDirective directive = (ProvidesDirective)obj;
            if (this.service != directive.service) return false;
            if (!this.impls.equals(directive.impls)) return false;
            return true;
        }

        public int hashCode() {
            return this.service.hashCode() * 31 + this.impls.hashCode() * 37;
        }
    }

    public static class OpensDirective
    extends Directive
    implements ModuleElement.OpensDirective {
        public final Symbol.PackageSymbol packge;
        public final List<Symbol.ModuleSymbol> modules;
        public final Set<OpensFlag> flags;

        public OpensDirective(Symbol.PackageSymbol packge, List<Symbol.ModuleSymbol> modules) {
            this(packge, modules, EnumSet.noneOf(OpensFlag.class));
        }

        public OpensDirective(Symbol.PackageSymbol packge, List<Symbol.ModuleSymbol> modules, Set<OpensFlag> flags) {
            this.packge = packge;
            this.modules = modules;
            this.flags = flags;
        }

        @Override
        public ModuleElement.DirectiveKind getKind() {
            return ModuleElement.DirectiveKind.OPENS;
        }

        @Override
        public Symbol.PackageSymbol getPackage() {
            return this.packge;
        }

        public java.util.List<Symbol.ModuleSymbol> getTargetModules() {
            return this.modules == null ? null : Collections.unmodifiableList(this.modules);
        }

        public String toString() {
            if (this.modules == null) {
                return "Opens[" + this.packge + "]";
            }
            return "Opens[" + this.packge + ":" + this.modules + "]";
        }

        @Override
        public <R, P> R accept(ModuleElement.DirectiveVisitor<R, P> v, P p) {
            return v.visitOpens(this, p);
        }
    }

    public static enum OpensFlag {
        SYNTHETIC(4096),
        MANDATED(32768);

        public final int value;

        public static int value(Set<OpensFlag> s) {
            int v = 0;
            for (OpensFlag f : s) {
                v |= f.value;
            }
            return v;
        }

        private OpensFlag(int value) {
            this.value = value;
        }
    }

    public static class ExportsDirective
    extends Directive
    implements ModuleElement.ExportsDirective {
        public final Symbol.PackageSymbol packge;
        public final List<Symbol.ModuleSymbol> modules;
        public final Set<ExportsFlag> flags;

        public ExportsDirective(Symbol.PackageSymbol packge, List<Symbol.ModuleSymbol> modules) {
            this(packge, modules, EnumSet.noneOf(ExportsFlag.class));
        }

        public ExportsDirective(Symbol.PackageSymbol packge, List<Symbol.ModuleSymbol> modules, Set<ExportsFlag> flags) {
            this.packge = packge;
            this.modules = modules;
            this.flags = flags;
        }

        @Override
        public ModuleElement.DirectiveKind getKind() {
            return ModuleElement.DirectiveKind.EXPORTS;
        }

        @Override
        public Symbol.PackageSymbol getPackage() {
            return this.packge;
        }

        public java.util.List<Symbol.ModuleSymbol> getTargetModules() {
            return this.modules == null ? null : Collections.unmodifiableList(this.modules);
        }

        public String toString() {
            if (this.modules == null) {
                return "Exports[" + this.packge + "]";
            }
            return "Exports[" + this.packge + ":" + this.modules + "]";
        }

        @Override
        public <R, P> R accept(ModuleElement.DirectiveVisitor<R, P> v, P p) {
            return v.visitExports(this, p);
        }
    }

    public static enum ExportsFlag {
        SYNTHETIC(4096),
        MANDATED(32768);

        public final int value;

        public static int value(Set<ExportsFlag> s) {
            int v = 0;
            for (ExportsFlag f : s) {
                v |= f.value;
            }
            return v;
        }

        private ExportsFlag(int value) {
            this.value = value;
        }
    }

    public static enum RequiresFlag {
        TRANSITIVE(32),
        STATIC_PHASE(64),
        SYNTHETIC(4096),
        MANDATED(32768),
        EXTRA(65536);

        public final int value;

        public static int value(Set<RequiresFlag> s) {
            int v = 0;
            for (RequiresFlag f : s) {
                v |= f.value;
            }
            return v;
        }

        private RequiresFlag(int value) {
            this.value = value;
        }

        public String toString() {
            return String.format("ACC_%s (0x%04x)", this.name(), this.value);
        }
    }
}

