/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import jakarta.faces.component.UICommand;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.component.visit.VisitCallback;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.SupportFieldId;
import org.apache.myfaces.tobago.component.SupportsAccessKey;
import org.apache.myfaces.tobago.component.SupportsAutoSpacing;
import org.apache.myfaces.tobago.component.Visual;
import org.apache.myfaces.tobago.internal.component.AbstractUICommandBase;
import org.apache.myfaces.tobago.internal.component.AbstractUIEvent;
import org.apache.myfaces.tobago.util.ComponentUtils;

public abstract class AbstractUICommand
extends AbstractUICommandBase
implements SupportsAutoSpacing,
SupportsAccessKey,
Visual,
ClientBehaviorHolder,
SupportFieldId {
    private Boolean parentOfCommands;

    public boolean isParentOfCommands() {
        if (this.parentOfCommands == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ParentOfCommandVisitor visitor = new ParentOfCommandVisitor(facesContext, this.getClientId(facesContext));
            this.visitTree(VisitContext.createVisitContext((FacesContext)facesContext, null, ComponentUtils.SET_SKIP_UNRENDERED), visitor);
            this.parentOfCommands = visitor.isParentOfCommands();
        }
        return this.parentOfCommands;
    }

    public abstract String getImage();

    @Override
    public abstract String getLabel();

    @Override
    public String getFieldId(FacesContext facesContext) {
        if (this.isParentOfCommands()) {
            return this.getClientId(facesContext) + "::command";
        }
        return this.getClientId(facesContext);
    }

    private static class ParentOfCommandVisitor
    implements VisitCallback {
        private boolean parentOfCommands = false;
        private final FacesContext facesContext;
        private final String clientId;

        private ParentOfCommandVisitor(FacesContext facesContext, String clientId) {
            this.facesContext = facesContext;
            this.clientId = clientId;
        }

        public VisitResult visit(VisitContext context, UIComponent target) {
            if (!target.getClientId(this.facesContext).equals(this.clientId) && (target instanceof Visual && !((Visual)target).isPlain() || ComponentUtils.isStandardHtmlRendererType(target))) {
                if (!(target instanceof AbstractUIEvent) && (target instanceof UICommand || target instanceof UIInput)) {
                    this.parentOfCommands = true;
                    return VisitResult.COMPLETE;
                }
                return VisitResult.ACCEPT;
            }
            return VisitResult.ACCEPT;
        }

        public boolean isParentOfCommands() {
            return this.parentOfCommands;
        }
    }

    static enum PropertyKeys {
        disabled;

    }
}

