/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.component;

import jakarta.el.ELContext;
import jakarta.el.ValueExpression;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.context.FacesContext;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.Visual;
import org.apache.myfaces.tobago.internal.component.AbstractUIData;
import org.apache.myfaces.tobago.model.ExpandedState;
import org.apache.myfaces.tobago.model.ScrollPosition;
import org.apache.myfaces.tobago.model.SelectedState;
import org.apache.myfaces.tobago.model.TreeState;

public abstract class AbstractUITree
extends AbstractUIData
implements NamingContainer,
Visual {
    public static final String SUFFIX_PARENT = "parent";
    private TreeState state;
    private String baseClientId;

    public String getBaseClientId(FacesContext facesContext) {
        if (this.baseClientId == null) {
            char separatorChar;
            String separatorRowIndex;
            String clientId = super.getClientId(facesContext);
            this.baseClientId = clientId.endsWith(separatorRowIndex = (separatorChar = UINamingContainer.getSeparatorChar((FacesContext)FacesContext.getCurrentInstance())) + String.valueOf(this.getRowIndex())) ? clientId.substring(0, clientId.indexOf(separatorRowIndex)) : clientId;
        }
        return this.baseClientId;
    }

    public void processValidators(FacesContext facesContext) {
        int last = this.isRowsUnlimited() ? Integer.MAX_VALUE : this.getFirst() + this.getRows();
        for (int rowIndex = this.getFirst(); rowIndex < last; ++rowIndex) {
            this.setRowIndex(rowIndex);
            if (!this.isRowAvailable()) break;
            for (UIComponent child : this.getChildren()) {
                child.processValidators(facesContext);
            }
        }
        this.setRowIndex(-1);
    }

    public void processUpdates(FacesContext facesContext) {
        int last = this.isRowsUnlimited() ? Integer.MAX_VALUE : this.getFirst() + this.getRows();
        for (int rowIndex = this.getFirst(); rowIndex < last; ++rowIndex) {
            this.setRowIndex(rowIndex);
            if (!this.isRowAvailable()) break;
            for (UIComponent child : this.getChildren()) {
                child.processUpdates(facesContext);
            }
        }
        this.setRowIndex(-1);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void processDecodes(FacesContext facesContext) {
        if (!this.isRendered()) {
            return;
        }
        int last = this.isRowsUnlimited() ? Integer.MAX_VALUE : this.getFirst() + this.getRows();
        for (int rowIndex = this.getFirst(); rowIndex < last; ++rowIndex) {
            this.setRowIndex(rowIndex);
            if (!this.isRowAvailable()) break;
            for (UIComponent child : this.getChildren()) {
                child.processDecodes(facesContext);
            }
        }
        this.setRowIndex(-1);
        this.decode(facesContext);
    }

    public void setState(TreeState state) {
        this.state = state;
    }

    public TreeState getState() {
        if (this.state != null) {
            return this.state;
        }
        ELContext elContext = FacesContext.getCurrentInstance().getELContext();
        ValueExpression expression = this.getValueExpression(Attributes.state.getName());
        if (expression != null) {
            TreeState treeState = (TreeState)expression.getValue(elContext);
            if (treeState == null) {
                treeState = new TreeState(new ExpandedState(2), new SelectedState(), new ScrollPosition());
                expression.setValue(elContext, (Object)treeState);
            }
            return treeState;
        }
        this.state = new TreeState(new ExpandedState(2), new SelectedState(), new ScrollPosition());
        return this.state;
    }

    @Override
    public SelectedState getSelectedState() {
        return this.getState().getSelectedState();
    }

    @Override
    public ExpandedState getExpandedState() {
        return this.getState().getExpandedState();
    }

    public void restoreState(FacesContext context, Object componentState) {
        Object[] values = (Object[])componentState;
        super.restoreState(context, values[0]);
        this.state = (TreeState)values[1];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.state};
        return values;
    }
}

