/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.filters;

import java.io.IOException;
import java.util.Objects;
import java.util.logging.Level;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.filter.BufferInputHandler;
import org.apache.sshd.common.filter.InputHandler;
import org.apache.sshd.common.filter.IoFilter;
import org.apache.sshd.common.filter.OutputHandler;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.filters.CryptStatisticsProvider;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.logging.LoggingUtils;
import org.apache.sshd.common.util.logging.SimplifiedLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketLoggingFilter
extends IoFilter {
    private static final Logger LOG = LoggerFactory.getLogger(PacketLoggingFilter.class);
    private static final SimplifiedLog SIMPLE = LoggingUtils.wrap(LOG);
    private final InputHandler input;
    private final OutputHandler output;

    public PacketLoggingFilter(final Session session, final CryptStatisticsProvider crypt) {
        Objects.requireNonNull(session);
        Objects.requireNonNull(crypt);
        this.input = new BufferInputHandler(){
            final /* synthetic */ PacketLoggingFilter this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void handleMessage(Buffer message) throws Exception {
                if (LOG.isDebugEnabled()) {
                    int cmd = message.rawByte(message.rpos()) & 0xFF;
                    LOG.debug("receivePacket({}) packet #{} command={}[{}] len={}", new Object[]{session, crypt.getLastInputSequenceNumber(), cmd, SshConstants.getCommandMessageName(cmd), message.available()});
                }
                if (SIMPLE.isTraceEnabled()) {
                    message.dumpHex(SIMPLE, Level.FINEST, "receivePacket(" + session + ") packet #" + crypt.getLastInputSequenceNumber(), session);
                }
                this.this$0.owner().passOn(message);
            }
        };
        this.output = new OutputHandler(){
            final /* synthetic */ PacketLoggingFilter this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public synchronized IoWriteFuture send(int cmd, Buffer message) throws IOException {
                if (message != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("sendPacket({}) packet #{} command={}[{}] len={}", new Object[]{session, crypt.getOutputSequenceNumber(), cmd, SshConstants.getCommandMessageName(cmd), message.available()});
                    }
                    if (SIMPLE.isTraceEnabled()) {
                        message.dumpHex(SIMPLE, Level.FINEST, "sendPacket(" + session + ") packet #" + crypt.getOutputSequenceNumber(), session);
                    }
                }
                return this.this$0.owner().send(cmd, message);
            }
        };
    }

    @Override
    public InputHandler in() {
        return this.input;
    }

    @Override
    public OutputHandler out() {
        return this.output;
    }
}

