/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.webservices;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.soap.MTOM;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.BulkUpdateObjectIdAndChangeToken;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.impl.WSConverter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisAccessControlListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisAllowableActionsType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisBulkUpdateType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisContentStreamType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisExtensionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectIdAndChangeTokenType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertiesType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisRenditionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.DeleteTreeResponse;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumIncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumUnfileObject;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumVersioningState;
import org.apache.chemistry.opencmis.commons.impl.jaxb.ObjectServicePort;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.impl.webservices.AbstractService;

@MTOM
@WebService(endpointInterface="org.apache.chemistry.opencmis.commons.impl.jaxb.ObjectServicePort")
public class ObjectService
extends AbstractService
implements ObjectServicePort {
    @Resource
    public WebServiceContext wsContext;

    public void createDocument(String repositoryId, CmisPropertiesType properties, String folderId, CmisContentStreamType contentStream, EnumVersioningState versioningState, List<String> policies, CmisAccessControlListType addAces, CmisAccessControlListType removeAces, Holder<CmisExtensionType> extension, Holder<String> objectId) throws CmisException {
        String id;
        ExtensionsData extData;
        CmisService service;
        block8: {
            block7: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                extData = WSConverter.convertExtensionHolder(extension);
                if (!this.stopBeforeService(service)) break block7;
                this.closeService(service);
                return;
            }
            id = service.createDocument(repositoryId, WSConverter.convert((CmisPropertiesType)properties), folderId, WSConverter.convert((CmisContentStreamType)contentStream, (boolean)false), (VersioningState)WSConverter.convert(VersioningState.class, (Enum)versioningState), policies, WSConverter.convert((CmisAccessControlListType)addAces, null), WSConverter.convert((CmisAccessControlListType)removeAces, null), extData);
            WSConverter.closeStream((CmisContentStreamType)contentStream);
            if (!this.stopAfterService(service)) break block8;
            this.closeService(service);
            return;
        }
        try {
            if (objectId != null) {
                objectId.value = id;
            }
            WSConverter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void createDocumentFromSource(String repositoryId, String sourceId, CmisPropertiesType properties, String folderId, EnumVersioningState versioningState, List<String> policies, CmisAccessControlListType addAces, CmisAccessControlListType removeAces, Holder<CmisExtensionType> extension, Holder<String> objectId) throws CmisException {
        String id;
        ExtensionsData extData;
        CmisService service;
        block8: {
            block7: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                extData = WSConverter.convertExtensionHolder(extension);
                if (!this.stopBeforeService(service)) break block7;
                this.closeService(service);
                return;
            }
            id = service.createDocumentFromSource(repositoryId, sourceId, WSConverter.convert((CmisPropertiesType)properties), folderId, (VersioningState)WSConverter.convert(VersioningState.class, (Enum)versioningState), policies, WSConverter.convert((CmisAccessControlListType)addAces, null), WSConverter.convert((CmisAccessControlListType)removeAces, null), extData);
            if (!this.stopAfterService(service)) break block8;
            this.closeService(service);
            return;
        }
        try {
            if (objectId != null) {
                objectId.value = id;
            }
            WSConverter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void createFolder(String repositoryId, CmisPropertiesType properties, String folderId, List<String> policies, CmisAccessControlListType addAces, CmisAccessControlListType removeAces, Holder<CmisExtensionType> extension, Holder<String> objectId) throws CmisException {
        String id;
        ExtensionsData extData;
        CmisService service;
        block8: {
            block7: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                extData = WSConverter.convertExtensionHolder(extension);
                if (!this.stopBeforeService(service)) break block7;
                this.closeService(service);
                return;
            }
            id = service.createFolder(repositoryId, WSConverter.convert((CmisPropertiesType)properties), folderId, policies, WSConverter.convert((CmisAccessControlListType)addAces, null), WSConverter.convert((CmisAccessControlListType)removeAces, null), extData);
            if (!this.stopAfterService(service)) break block8;
            this.closeService(service);
            return;
        }
        try {
            if (objectId != null) {
                objectId.value = id;
            }
            WSConverter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void createPolicy(String repositoryId, CmisPropertiesType properties, String folderId, List<String> policies, CmisAccessControlListType addAces, CmisAccessControlListType removeAces, Holder<CmisExtensionType> extension, Holder<String> objectId) throws CmisException {
        String id;
        ExtensionsData extData;
        CmisService service;
        block8: {
            block7: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                extData = WSConverter.convertExtensionHolder(extension);
                if (!this.stopBeforeService(service)) break block7;
                this.closeService(service);
                return;
            }
            id = service.createPolicy(repositoryId, WSConverter.convert((CmisPropertiesType)properties), folderId, policies, WSConverter.convert((CmisAccessControlListType)addAces, null), WSConverter.convert((CmisAccessControlListType)removeAces, null), extData);
            if (!this.stopAfterService(service)) break block8;
            this.closeService(service);
            return;
        }
        try {
            if (objectId != null) {
                objectId.value = id;
            }
            WSConverter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void createRelationship(String repositoryId, CmisPropertiesType properties, List<String> policies, CmisAccessControlListType addAces, CmisAccessControlListType removeAces, Holder<CmisExtensionType> extension, Holder<String> objectId) throws CmisException {
        String id;
        ExtensionsData extData;
        CmisService service;
        block8: {
            block7: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                extData = WSConverter.convertExtensionHolder(extension);
                if (!this.stopBeforeService(service)) break block7;
                this.closeService(service);
                return;
            }
            id = service.createRelationship(repositoryId, WSConverter.convert((CmisPropertiesType)properties), policies, WSConverter.convert((CmisAccessControlListType)addAces, null), WSConverter.convert((CmisAccessControlListType)removeAces, null), extData);
            if (!this.stopAfterService(service)) break block8;
            this.closeService(service);
            return;
        }
        try {
            if (objectId != null) {
                objectId.value = id;
            }
            WSConverter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void createItem(String repositoryId, CmisPropertiesType properties, String folderId, CmisAccessControlListType addAces, CmisAccessControlListType removeAces, Holder<CmisExtensionType> extension, Holder<String> objectId) throws CmisException {
        String id;
        ExtensionsData extData;
        CmisService service;
        block8: {
            block7: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                extData = WSConverter.convertExtensionHolder(extension);
                if (!this.stopBeforeService(service)) break block7;
                this.closeService(service);
                return;
            }
            id = service.createItem(repositoryId, WSConverter.convert((CmisPropertiesType)properties), folderId, null, WSConverter.convert((CmisAccessControlListType)addAces, null), WSConverter.convert((CmisAccessControlListType)removeAces, null), extData);
            if (!this.stopAfterService(service)) break block8;
            this.closeService(service);
            return;
        }
        try {
            if (objectId != null) {
                objectId.value = id;
            }
            WSConverter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void deleteContentStream(String repositoryId, Holder<String> objectId, Holder<String> changeToken, Holder<CmisExtensionType> extension) throws CmisException {
        ExtensionsData extData;
        org.apache.chemistry.opencmis.commons.spi.Holder changeTokenHolder;
        org.apache.chemistry.opencmis.commons.spi.Holder objectIdHolder;
        CmisService service;
        block7: {
            block6: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                objectIdHolder = WSConverter.convertHolder(objectId);
                changeTokenHolder = WSConverter.convertHolder(changeToken);
                extData = WSConverter.convertExtensionHolder(extension);
                if (!this.stopBeforeService(service)) break block6;
                this.closeService(service);
                return;
            }
            service.deleteContentStream(repositoryId, objectIdHolder, changeTokenHolder, extData);
            if (!this.stopAfterService(service)) break block7;
            this.closeService(service);
            return;
        }
        try {
            WSConverter.setHolderValue((org.apache.chemistry.opencmis.commons.spi.Holder)objectIdHolder, objectId);
            WSConverter.setHolderValue((org.apache.chemistry.opencmis.commons.spi.Holder)changeTokenHolder, changeToken);
            WSConverter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void deleteObject(String repositoryId, String objectId, Boolean allVersions, Holder<CmisExtensionType> extension) throws CmisException {
        ExtensionsData extData;
        CmisService service;
        block7: {
            block6: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                extData = WSConverter.convertExtensionHolder(extension);
                if (!this.stopBeforeService(service)) break block6;
                this.closeService(service);
                return;
            }
            service.deleteObject(repositoryId, objectId, allVersions, extData);
            if (!this.stopAfterService(service)) break block7;
            this.closeService(service);
            return;
        }
        try {
            WSConverter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public DeleteTreeResponse.FailedToDelete deleteTree(String repositoryId, String folderId, Boolean allVersions, EnumUnfileObject unfileObjects, Boolean continueOnFailure, CmisExtensionType extension) throws CmisException {
        DeleteTreeResponse.FailedToDelete failedToDelete;
        FailedToDeleteData serviceResult;
        CmisService service;
        block7: {
            block6: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                if (!this.stopBeforeService(service)) break block6;
                DeleteTreeResponse.FailedToDelete failedToDelete2 = null;
                this.closeService(service);
                return failedToDelete2;
            }
            serviceResult = service.deleteTree(repositoryId, folderId, allVersions, (UnfileObject)WSConverter.convert(UnfileObject.class, (Enum)unfileObjects), continueOnFailure, WSConverter.convert((CmisExtensionType)extension));
            if (!this.stopAfterService(service)) break block7;
            DeleteTreeResponse.FailedToDelete failedToDelete3 = null;
            this.closeService(service);
            return failedToDelete3;
        }
        try {
            failedToDelete = WSConverter.convert((FailedToDeleteData)serviceResult);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return failedToDelete;
    }

    public CmisAllowableActionsType getAllowableActions(String repositoryId, String objectId, CmisExtensionType extension) throws CmisException {
        CmisAllowableActionsType cmisAllowableActionsType;
        AllowableActions serviceResult;
        CmisVersion cmisVersion;
        CmisService service;
        block7: {
            block6: {
                service = null;
                cmisVersion = null;
                service = this.getService(this.wsContext, repositoryId);
                cmisVersion = this.getCmisVersion(this.wsContext);
                if (!this.stopBeforeService(service)) break block6;
                CmisAllowableActionsType cmisAllowableActionsType2 = null;
                this.closeService(service);
                return cmisAllowableActionsType2;
            }
            serviceResult = service.getAllowableActions(repositoryId, objectId, WSConverter.convert((CmisExtensionType)extension));
            if (!this.stopAfterService(service)) break block7;
            CmisAllowableActionsType cmisAllowableActionsType3 = null;
            this.closeService(service);
            return cmisAllowableActionsType3;
        }
        try {
            cmisAllowableActionsType = WSConverter.convert((AllowableActions)serviceResult, (CmisVersion)cmisVersion);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisAllowableActionsType;
    }

    public CmisContentStreamType getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, CmisExtensionType extension) throws CmisException {
        CmisContentStreamType cmisContentStreamType;
        ContentStream serviceResult;
        CmisService service;
        block7: {
            block6: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                if (!this.stopBeforeService(service)) break block6;
                CmisContentStreamType cmisContentStreamType2 = null;
                this.closeService(service);
                return cmisContentStreamType2;
            }
            serviceResult = service.getContentStream(repositoryId, objectId, streamId, offset, length, WSConverter.convert((CmisExtensionType)extension));
            if (!this.stopAfterService(service)) break block7;
            CmisContentStreamType cmisContentStreamType3 = null;
            this.closeService(service);
            return cmisContentStreamType3;
        }
        try {
            cmisContentStreamType = WSConverter.convert((ContentStream)serviceResult, (boolean)true);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisContentStreamType;
    }

    public CmisObjectType getObject(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, CmisExtensionType extension) throws CmisException {
        CmisObjectType cmisObjectType;
        ObjectData serviceResult;
        CmisVersion cmisVersion;
        CmisService service;
        block7: {
            block6: {
                service = null;
                cmisVersion = null;
                service = this.getService(this.wsContext, repositoryId);
                cmisVersion = this.getCmisVersion(this.wsContext);
                if (!this.stopBeforeService(service)) break block6;
                CmisObjectType cmisObjectType2 = null;
                this.closeService(service);
                return cmisObjectType2;
            }
            serviceResult = service.getObject(repositoryId, objectId, filter, includeAllowableActions, (IncludeRelationships)WSConverter.convert(IncludeRelationships.class, (Enum)includeRelationships), renditionFilter, includePolicyIds, includeAcl, WSConverter.convert((CmisExtensionType)extension));
            if (!this.stopAfterService(service)) break block7;
            CmisObjectType cmisObjectType3 = null;
            this.closeService(service);
            return cmisObjectType3;
        }
        try {
            cmisObjectType = WSConverter.convert((ObjectData)serviceResult, (CmisVersion)cmisVersion);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisObjectType;
    }

    public CmisObjectType getObjectByPath(String repositoryId, String path, String filter, Boolean includeAllowableActions, EnumIncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, CmisExtensionType extension) throws CmisException {
        CmisObjectType cmisObjectType;
        ObjectData serviceResult;
        CmisVersion cmisVersion;
        CmisService service;
        block7: {
            block6: {
                service = null;
                cmisVersion = null;
                service = this.getService(this.wsContext, repositoryId);
                cmisVersion = this.getCmisVersion(this.wsContext);
                if (!this.stopBeforeService(service)) break block6;
                CmisObjectType cmisObjectType2 = null;
                this.closeService(service);
                return cmisObjectType2;
            }
            serviceResult = service.getObjectByPath(repositoryId, path, filter, includeAllowableActions, (IncludeRelationships)WSConverter.convert(IncludeRelationships.class, (Enum)includeRelationships), renditionFilter, includePolicyIds, includeAcl, WSConverter.convert((CmisExtensionType)extension));
            if (!this.stopAfterService(service)) break block7;
            CmisObjectType cmisObjectType3 = null;
            this.closeService(service);
            return cmisObjectType3;
        }
        try {
            cmisObjectType = WSConverter.convert((ObjectData)serviceResult, (CmisVersion)cmisVersion);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisObjectType;
    }

    public CmisPropertiesType getProperties(String repositoryId, String objectId, String filter, CmisExtensionType extension) throws CmisException {
        CmisPropertiesType cmisPropertiesType;
        Properties serviceResult;
        CmisService service;
        block7: {
            block6: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                if (!this.stopBeforeService(service)) break block6;
                CmisPropertiesType cmisPropertiesType2 = null;
                this.closeService(service);
                return cmisPropertiesType2;
            }
            serviceResult = service.getProperties(repositoryId, objectId, filter, WSConverter.convert((CmisExtensionType)extension));
            if (!this.stopAfterService(service)) break block7;
            CmisPropertiesType cmisPropertiesType3 = null;
            this.closeService(service);
            return cmisPropertiesType3;
        }
        try {
            cmisPropertiesType = WSConverter.convert((Properties)serviceResult);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return cmisPropertiesType;
    }

    public List<CmisRenditionType> getRenditions(String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, CmisExtensionType extension) throws CmisException {
        ArrayList<CmisRenditionType> arrayList;
        List renditionList;
        ArrayList<CmisRenditionType> result;
        CmisService service;
        block9: {
            block8: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                result = new ArrayList<CmisRenditionType>();
                if (!this.stopBeforeService(service)) break block8;
                List<CmisRenditionType> list = null;
                this.closeService(service);
                return list;
            }
            renditionList = service.getRenditions(repositoryId, objectId, renditionFilter, maxItems, skipCount, WSConverter.convert((CmisExtensionType)extension));
            if (!this.stopAfterService(service)) break block9;
            List<CmisRenditionType> list = null;
            this.closeService(service);
            return list;
        }
        try {
            if (renditionList != null) {
                for (RenditionData rendition : renditionList) {
                    result.add(WSConverter.convert((RenditionData)rendition));
                }
            }
            arrayList = result;
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
        return arrayList;
    }

    public void moveObject(String repositoryId, Holder<String> objectId, String targetFolderId, String sourceFolderId, Holder<CmisExtensionType> extension) throws CmisException {
        ExtensionsData extData;
        org.apache.chemistry.opencmis.commons.spi.Holder objectIdHolder;
        CmisService service;
        block7: {
            block6: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                objectIdHolder = WSConverter.convertHolder(objectId);
                extData = WSConverter.convertExtensionHolder(extension);
                if (!this.stopBeforeService(service)) break block6;
                this.closeService(service);
                return;
            }
            service.moveObject(repositoryId, objectIdHolder, targetFolderId, sourceFolderId, extData);
            if (!this.stopAfterService(service)) break block7;
            this.closeService(service);
            return;
        }
        try {
            WSConverter.setHolderValue((org.apache.chemistry.opencmis.commons.spi.Holder)objectIdHolder, objectId);
            WSConverter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void setContentStream(String repositoryId, Holder<String> objectId, Boolean overwriteFlag, Holder<String> changeToken, CmisContentStreamType contentStream, Holder<CmisExtensionType> extension) throws CmisException {
        ExtensionsData extData;
        org.apache.chemistry.opencmis.commons.spi.Holder changeTokenHolder;
        org.apache.chemistry.opencmis.commons.spi.Holder objectIdHolder;
        CmisService service;
        block7: {
            block6: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                objectIdHolder = WSConverter.convertHolder(objectId);
                changeTokenHolder = WSConverter.convertHolder(changeToken);
                extData = WSConverter.convertExtensionHolder(extension);
                if (!this.stopBeforeService(service)) break block6;
                this.closeService(service);
                return;
            }
            service.setContentStream(repositoryId, objectIdHolder, overwriteFlag, changeTokenHolder, WSConverter.convert((CmisContentStreamType)contentStream, (boolean)false), extData);
            WSConverter.closeStream((CmisContentStreamType)contentStream);
            if (!this.stopAfterService(service)) break block7;
            this.closeService(service);
            return;
        }
        try {
            WSConverter.setHolderValue((org.apache.chemistry.opencmis.commons.spi.Holder)objectIdHolder, objectId);
            WSConverter.setHolderValue((org.apache.chemistry.opencmis.commons.spi.Holder)changeTokenHolder, changeToken);
            WSConverter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void appendContentStream(String repositoryId, Holder<String> objectId, Boolean isLastChunk, Holder<String> changeToken, CmisContentStreamType contentStream, Holder<CmisExtensionType> extension) throws CmisException {
        ExtensionsData extData;
        org.apache.chemistry.opencmis.commons.spi.Holder changeTokenHolder;
        org.apache.chemistry.opencmis.commons.spi.Holder objectIdHolder;
        CmisService service;
        block7: {
            block6: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                objectIdHolder = WSConverter.convertHolder(objectId);
                changeTokenHolder = WSConverter.convertHolder(changeToken);
                extData = WSConverter.convertExtensionHolder(extension);
                if (!this.stopBeforeService(service)) break block6;
                this.closeService(service);
                return;
            }
            service.appendContentStream(repositoryId, objectIdHolder, changeTokenHolder, WSConverter.convert((CmisContentStreamType)contentStream, (boolean)true), isLastChunk.booleanValue(), extData);
            WSConverter.closeStream((CmisContentStreamType)contentStream);
            if (!this.stopAfterService(service)) break block7;
            this.closeService(service);
            return;
        }
        try {
            WSConverter.setHolderValue((org.apache.chemistry.opencmis.commons.spi.Holder)objectIdHolder, objectId);
            WSConverter.setHolderValue((org.apache.chemistry.opencmis.commons.spi.Holder)changeTokenHolder, changeToken);
            WSConverter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void updateProperties(String repositoryId, Holder<String> objectId, Holder<String> changeToken, CmisPropertiesType properties, Holder<CmisExtensionType> extension) throws CmisException {
        ExtensionsData extData;
        org.apache.chemistry.opencmis.commons.spi.Holder changeTokenHolder;
        org.apache.chemistry.opencmis.commons.spi.Holder objectIdHolder;
        CmisService service;
        block7: {
            block6: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                objectIdHolder = WSConverter.convertHolder(objectId);
                changeTokenHolder = WSConverter.convertHolder(changeToken);
                extData = WSConverter.convertExtensionHolder(extension);
                if (!this.stopBeforeService(service)) break block6;
                this.closeService(service);
                return;
            }
            service.updateProperties(repositoryId, objectIdHolder, changeTokenHolder, WSConverter.convert((CmisPropertiesType)properties), extData);
            if (!this.stopAfterService(service)) break block7;
            this.closeService(service);
            return;
        }
        try {
            WSConverter.setHolderValue((org.apache.chemistry.opencmis.commons.spi.Holder)objectIdHolder, objectId);
            WSConverter.setHolderValue((org.apache.chemistry.opencmis.commons.spi.Holder)changeTokenHolder, changeToken);
            WSConverter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }

    public void bulkUpdateProperties(String repositoryId, CmisBulkUpdateType bulkUpdateData, Holder<CmisExtensionType> extension, Holder<CmisObjectIdAndChangeTokenType> objectIdAndChangeToken) throws CmisException {
        List result;
        ExtensionsData extData;
        CmisService service;
        block13: {
            List removeSecondaryTypeIds;
            List addSecondaryTypeIds;
            Properties properties;
            ArrayList<BulkUpdateObjectIdAndChangeToken> objectIdsAndChangeTokens;
            block12: {
                service = null;
                service = this.getService(this.wsContext, repositoryId);
                extData = WSConverter.convertExtensionHolder(extension);
                objectIdsAndChangeTokens = null;
                properties = null;
                addSecondaryTypeIds = null;
                removeSecondaryTypeIds = null;
                if (bulkUpdateData != null) {
                    if (!bulkUpdateData.getObjectIdAndChangeToken().isEmpty()) {
                        objectIdsAndChangeTokens = new ArrayList<BulkUpdateObjectIdAndChangeToken>();
                        for (CmisObjectIdAndChangeTokenType idAndToken : bulkUpdateData.getObjectIdAndChangeToken()) {
                            objectIdsAndChangeTokens.add(WSConverter.convert((CmisObjectIdAndChangeTokenType)idAndToken));
                        }
                    }
                    properties = WSConverter.convert((CmisPropertiesType)bulkUpdateData.getProperties());
                    if (!bulkUpdateData.getAddSecondaryTypeIds().isEmpty()) {
                        addSecondaryTypeIds = bulkUpdateData.getAddSecondaryTypeIds();
                    }
                    if (!bulkUpdateData.getRemoveSecondaryTypeIds().isEmpty()) {
                        removeSecondaryTypeIds = bulkUpdateData.getRemoveSecondaryTypeIds();
                    }
                }
                if (!this.stopBeforeService(service)) break block12;
                this.closeService(service);
                return;
            }
            result = service.bulkUpdateProperties(repositoryId, objectIdsAndChangeTokens, properties, addSecondaryTypeIds, removeSecondaryTypeIds, extData);
            if (!this.stopAfterService(service)) break block13;
            this.closeService(service);
            return;
        }
        try {
            if (objectIdAndChangeToken == null || result != null) {
                // empty if block
            }
            WSConverter.setExtensionValues((ExtensionsData)extData, extension);
        }
        catch (Exception e) {
            try {
                throw this.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeService(service);
                throw throwable;
            }
        }
        this.closeService(service);
    }
}

