/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.OutputStream;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.chemistry.opencmis.commons.impl.XMLUtils;

public abstract class XMLDocumentBase {
    private XMLStreamWriter writer;
    private Map<String, String> namespaces;

    public void setNamespaces(Map<String, String> namespaces) throws XMLStreamException {
        this.writer.setPrefix("atom", "http://www.w3.org/2005/Atom");
        this.writer.setPrefix("cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/");
        this.writer.setPrefix("cmisra", "http://docs.oasis-open.org/ns/cmis/restatom/200908/");
        this.writer.setPrefix("app", "http://www.w3.org/2007/app");
        if (namespaces != null) {
            this.namespaces = namespaces;
            for (Map.Entry<String, String> ns : namespaces.entrySet()) {
                this.writer.setPrefix(ns.getKey(), ns.getValue());
            }
        }
    }

    public void writeAllCustomNamespace() throws XMLStreamException {
        if (this.namespaces != null) {
            for (Map.Entry<String, String> ns : this.namespaces.entrySet()) {
                this.writer.writeNamespace(ns.getKey(), ns.getValue());
            }
        }
    }

    public void startDocument(OutputStream out, Map<String, String> namespaces) throws XMLStreamException {
        this.writer = XMLUtils.createWriter((OutputStream)out);
        this.writer.writeStartDocument("UTF-8", "1.0");
        this.setNamespaces(namespaces);
    }

    public void endDocument() throws XMLStreamException {
        if (this.writer == null) {
            return;
        }
        this.writer.writeEndDocument();
        this.writer.close();
    }

    public XMLStreamWriter getWriter() {
        return this.writer;
    }

    protected void setWriter(XMLStreamWriter writer) {
        this.writer = writer;
    }
}

